/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.helpshift.logger.model.LogModel;
import com.helpshift.static_classes.ErrorReporting;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSReview;
import com.helpshift.support.HSStorage;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftConnectionUtil;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.TimeUtil;
import com.helpshift.util.concurrent.ApiExecutor;
import com.helpshift.util.concurrent.ApiExecutorFactory;
import java.util.List;

@TargetApi(value=14)
final class HSLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private static HSLifecycleCallbacks instance = null;
    static HSApiData data = null;
    static HSStorage storage = null;
    static int started;
    static int stopped;
    static boolean isForeground;
    static boolean isConfigurationChanged;

    private HSLifecycleCallbacks() {
    }

    public static HSLifecycleCallbacks getInstance() {
        if (instance == null) {
            instance = new HSLifecycleCallbacks();
        }
        return instance;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
        final Context context = activity.getApplicationContext();
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!isConfigurationChanged) {
                    if (data == null) {
                        data = new HSApiData(context);
                        storage = HSLifecycleCallbacks.data.storage;
                    }
                    ++started;
                    if (!isForeground) {
                        data.updateReviewCounter();
                        if (data.shouldShowReviewPopup().booleanValue()) {
                            Intent i = new Intent(context, HSReview.class);
                            i.setFlags(0x10000000);
                            context.startActivity(i);
                        }
                        HelpshiftContext.getCoreApi().fetchServerConfig();
                        HelpshiftContext.getCoreApi().sendFailedApiCalls();
                        HelpshiftContext.getCoreApi().getConversationInboxPoller().refreshPollerOnAppForeground();
                        HelpshiftContext.getCoreApi().sendAppStartEvent();
                        boolean isNetworkAvailable = HelpshiftConnectionUtil.isOnline(context);
                        1 var2_3 = this;
                        synchronized (var2_3) {
                            if (isNetworkAvailable && ErrorReporting.isEnabled()) {
                                List<LogModel> logs;
                                boolean hasExceededBatchTime;
                                long lastReportedTime = storage.getLastErrorReportedTime();
                                float serverTimeDelta = HelpshiftContext.getPlatform().getNetworkRequestDAO().getServerTimeDelta();
                                long currentElapsedTime = TimeUtil.getAdjustedTimeInMillis(Float.valueOf(serverTimeDelta));
                                boolean bl = hasExceededBatchTime = currentElapsedTime - lastReportedTime > 86400000L;
                                if (hasExceededBatchTime && HSLogger.getFatalLogsCount() > 0 && (logs = HSLogger.getAll()) != null && !logs.isEmpty()) {
                                    storage.setLastErrorReportedTime(currentElapsedTime);
                                    data.sendErrorReports(logs);
                                }
                            }
                        }
                    }
                    isForeground = true;
                }
                isConfigurationChanged = false;
            }
        });
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        final boolean hasConfigChanged = activity != null && activity.isChangingConfigurations();
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                isConfigurationChanged = hasConfigChanged;
                if (!isConfigurationChanged && started == ++stopped) {
                    isForeground = false;
                    HelpshiftContext.getCoreApi().getConversationInboxPoller().stop();
                }
            }
        });
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    static {
        isConfigurationChanged = false;
    }
}

