/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.text.Html;
import com.helpshift.support.Faq;
import com.helpshift.support.RankComparator;
import com.helpshift.support.external.DoubleMetaphone;
import com.helpshift.support.model.FaqSearchIndex;
import com.helpshift.support.model.FuzzySearchToken;
import com.helpshift.support.model.TfIdfSearchToken;
import com.helpshift.support.search.SearchTokenDao;
import com.helpshift.support.search.SearchTokenDto;
import com.helpshift.support.search.storage.SearchTokenDaoImpl;
import com.helpshift.support.search.tfidf.PageIndexTrie;
import com.helpshift.support.util.HSTransliterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HSSearch {
    private static DoubleMetaphone metaPhone = new DoubleMetaphone();
    private static boolean indexing = false;
    private static boolean markDeinit = false;
    private static HashMap<String, String[]> characterTable;
    private static final Pattern patternGenerateToken;

    public static void init() {
        if (!indexing) {
            Thread indexThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    HSTransliterator.init();
                }
            }, "HS-trnsltrtr");
            indexThread.setDaemon(true);
            indexThread.start();
        }
    }

    public static void deinit() {
        if (!indexing) {
            HSTransliterator.deinit();
        } else {
            markDeinit = true;
        }
        characterTable = null;
    }

    public static String escapeHtml(String html) {
        return Html.fromHtml((String)html).toString();
    }

    public static String stripHtml(String html) {
        return html.replaceAll("<[^<>]+>", "");
    }

    public static ArrayList<String> generateTokens(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher m = patternGenerateToken.matcher(str);
        while (m.find()) {
            if (m.group(0).length() <= 2) continue;
            tokens.add(m.group(0));
        }
        return tokens;
    }

    public static ArrayList<String> generateTokensForSearchQuery(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher m = patternGenerateToken.matcher(str);
        while (m.find()) {
            if (m.group(0).length() <= 2 && str.length() <= 2) continue;
            tokens.add(m.group(0));
        }
        return tokens;
    }

    public static ArrayList<TfIdfSearchToken> generateVariations(String word, int type) {
        HashSet<TfIdfSearchToken> output = new HashSet<TfIdfSearchToken>();
        output.add(new TfIdfSearchToken(word, type));
        String metaphone = metaPhone.doubleMetaphone(word, false);
        if (metaphone != null) {
            output.add(new TfIdfSearchToken(metaphone.toLowerCase(), 50));
        }
        return new ArrayList<TfIdfSearchToken>(output);
    }

    public static ArrayList<TfIdfSearchToken> generateSearchVariations(String word) {
        return HSSearch.generateVariations(word, 10);
    }

    private static boolean isMetaTypeMatching(int firstType, int secondType) {
        if (50 == firstType || 50 == secondType) {
            return firstType == secondType;
        }
        return true;
    }

    public static String sanitize(String str) {
        String htmlText = HSSearch.escapeHtml(HSSearch.stripHtml(str));
        return HSTransliterator.unidecode(htmlText.toLowerCase());
    }

    public static final int calcFreq(int length, int type) {
        if (length == 1) {
            return 5;
        }
        if (40 == type) {
            return length;
        }
        if (10 == type) {
            return 30;
        }
        if (50 == type) {
            return 1;
        }
        if (20 == type) {
            return 300;
        }
        if (30 == type) {
            return 150;
        }
        return 1;
    }

    private static void buildPageIndexTrie(PageIndexTrie pageIndexTrie, String title, String doc, List<String> tags, int index) {
        HSSearch.generateAndAddString(pageIndexTrie, HSSearch.generateTokens(HSSearch.sanitize(title)), 20, index);
        ArrayList<String> tagsTokenList = new ArrayList<String>();
        for (String tag : tags) {
            tagsTokenList.addAll(HSSearch.generateTokens(tag));
        }
        HSSearch.generateAndAddString(pageIndexTrie, tagsTokenList, 30, index);
        HSSearch.generateAndAddString(pageIndexTrie, HSSearch.generateTokens(HSSearch.sanitize(doc)), 10, index);
    }

    private static void generateAndAddString(PageIndexTrie pageIndexTrie, List<String> data, int type, int index) {
        for (String str : data) {
            for (TfIdfSearchToken token : HSSearch.generateVariations(str, type)) {
                pageIndexTrie.insert(token.value, token.type, index);
            }
        }
    }

    public static FaqSearchIndex indexDocuments(ArrayList<Faq> docs) {
        if (indexing) {
            return null;
        }
        if (!HSTransliterator.isLoaded()) {
            HSTransliterator.init();
            markDeinit = true;
        }
        indexing = true;
        Map<String, List<FuzzySearchToken>> fuzzyIndex = HSSearch.buildFuzzyIndex(docs);
        HSSearch.buildTfidfIndex(docs);
        FaqSearchIndex searchIndex = new FaqSearchIndex(fuzzyIndex);
        indexing = false;
        if (markDeinit) {
            HSSearch.deinit();
            markDeinit = false;
        }
        return searchIndex;
    }

    protected static ArrayList<TfIdfSearchToken> filterSearchQuery(ArrayList<TfIdfSearchToken> queryTerms, HS_SEARCH_OPTIONS options) {
        ArrayList<TfIdfSearchToken> terms = new ArrayList<TfIdfSearchToken>();
        for (TfIdfSearchToken token : queryTerms) {
            int type = token.type;
            if (options == HS_SEARCH_OPTIONS.FULL_SEARCH) {
                terms.add(token);
                continue;
            }
            if (options == HS_SEARCH_OPTIONS.METAPHONE_SEARCH && 50 == type) {
                terms.add(token);
                continue;
            }
            if (options != HS_SEARCH_OPTIONS.KEYWORD_SEARCH || 10 != type && 40 != type) continue;
            terms.add(token);
        }
        return terms;
    }

    public static ArrayList<HashMap> queryDocs(String query, HS_SEARCH_OPTIONS options) {
        HashMap<String, Double> docRanks = new HashMap<String, Double>();
        HashSet resultDocSet = null;
        HashMap matchedTermsMap = new HashMap();
        ArrayList<TfIdfSearchToken> terms = new ArrayList<TfIdfSearchToken>();
        for (String string2 : HSSearch.generateTokensForSearchQuery(HSSearch.sanitize(query))) {
            terms.addAll(HSSearch.filterSearchQuery(HSSearch.generateSearchVariations(string2), options));
        }
        SearchTokenDao searchTokenDao = SearchTokenDaoImpl.getInstance();
        if (searchTokenDao != null) {
            for (TfIdfSearchToken searchQuery : terms) {
                String searchQueryTerm = searchQuery.value;
                int searchQueryType = searchQuery.type;
                SearchTokenDto searchToken = searchTokenDao.get(searchQueryTerm);
                if (searchToken == null || !HSSearch.isMetaTypeMatching(searchToken.wordType, searchQuery.type)) continue;
                Map<Integer, Double> tmpTermDocMap = searchToken.scoreMap;
                HashMap<String, Double> termDocMap = new HashMap<String, Double>();
                for (Integer key : tmpTermDocMap.keySet()) {
                    termDocMap.put(String.valueOf(key), tmpTermDocMap.get(key));
                }
                if (termDocMap == null || termDocMap.keySet().size() <= 0) continue;
                for (String docId : termDocMap.keySet()) {
                    ArrayList<String> matchTerms = (ArrayList<String>)matchedTermsMap.get(docId);
                    if (matchTerms == null) {
                        matchTerms = new ArrayList<String>();
                    }
                    if (searchQueryTerm.length() > 0) {
                        matchTerms.add(searchQueryTerm);
                    }
                    matchedTermsMap.put(docId, matchTerms);
                    Double docTFID = (Double)termDocMap.get(docId);
                    Double docRank = docRanks.get(docId);
                    Double docContribution = docTFID * (double)HSSearch.calcFreq(searchQueryTerm.length(), searchQueryType);
                    if (docRank != null) {
                        docRanks.put(docId, docRank + docContribution);
                        continue;
                    }
                    docRanks.put(docId, docContribution);
                }
                HashSet termDocSet = new HashSet();
                termDocSet.addAll(termDocMap.keySet());
                if (resultDocSet != null && !resultDocSet.isEmpty()) {
                    resultDocSet.addAll(termDocSet);
                    continue;
                }
                resultDocSet = new HashSet(termDocSet);
            }
        }
        if (resultDocSet == null || resultDocSet.isEmpty()) {
            RankComparator rankComparator = new RankComparator(docRanks);
            TreeMap<String, Double> sortedDocRanks = new TreeMap<String, Double>(rankComparator);
            sortedDocRanks.putAll(docRanks);
            return HSSearch.sortMatchedTermsMap(sortedDocRanks, matchedTermsMap);
        }
        if (resultDocSet.size() == 1) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList resultDoc = new ArrayList();
            String docId = (String)resultDocSet.iterator().next();
            hashMap.put("f", docId);
            hashMap.put("t", (String)matchedTermsMap.get(docId));
            resultDoc.add(hashMap);
            return resultDoc;
        }
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (String docId : resultDocSet) {
            hashMap.put(docId, docRanks.get(docId));
        }
        RankComparator docRankComp = new RankComparator(hashMap);
        TreeMap<String, Double> sortedDocRanks = new TreeMap<String, Double>(docRankComp);
        sortedDocRanks.putAll(hashMap);
        return HSSearch.sortMatchedTermsMap(sortedDocRanks, matchedTermsMap);
    }

    private static ArrayList<HashMap> sortMatchedTermsMap(TreeMap sortedDocRanks, HashMap matchedTermsMap) {
        ArrayList<HashMap> sortedResults = new ArrayList<HashMap>();
        Set sortedDocIds = sortedDocRanks.keySet();
        for (String docId : sortedDocIds) {
            HashMap<String, String> docIdTermsMap = new HashMap<String, String>();
            docIdTermsMap.put("f", docId);
            docIdTermsMap.put("t", (String)matchedTermsMap.get(docId));
            sortedResults.add(docIdTermsMap);
        }
        return sortedResults;
    }

    public static int getTermWeight(int type) {
        int weight = 1;
        if (type == 20) {
            weight = 5;
        } else if (type == 30) {
            weight = 3;
        }
        return weight;
    }

    protected static void buildTfidfIndex(ArrayList<Faq> docs) {
        int totalDocNum = docs.size();
        PageIndexTrie pageIndexTrie = new PageIndexTrie(totalDocNum);
        for (int docIndex = 0; docIndex < totalDocNum; ++docIndex) {
            Faq faq = docs.get(docIndex);
            HSSearch.buildPageIndexTrie(pageIndexTrie, faq.title, faq.body, faq.getTags(), docIndex);
        }
        pageIndexTrie.createAndStoreTfIdfIndex();
    }

    protected static Map<String, List<FuzzySearchToken>> buildFuzzyIndex(ArrayList<Faq> docs) {
        HashMap<String, List<FuzzySearchToken>> fuzzyIndex = new HashMap<String, List<FuzzySearchToken>>();
        int i = 0;
        for (Faq doc : docs) {
            String title = doc.title;
            for (String token : HSSearch.generateTokens(HSSearch.sanitize(title))) {
                if ((token = token.toLowerCase()).length() <= 3) continue;
                FuzzySearchToken fuzzySearchToken = new FuzzySearchToken(token, i + "");
                String firstCharacter = token.substring(0, 1);
                ArrayList<FuzzySearchToken> firstCharWordList = (ArrayList<FuzzySearchToken>)fuzzyIndex.get(firstCharacter);
                if (firstCharWordList == null) {
                    firstCharWordList = new ArrayList<FuzzySearchToken>();
                }
                firstCharWordList.add(fuzzySearchToken);
                fuzzyIndex.put(firstCharacter, firstCharWordList);
                String secondCharacter = token.substring(1, 2);
                ArrayList<FuzzySearchToken> secondCharWordList = (ArrayList<FuzzySearchToken>)fuzzyIndex.get(secondCharacter);
                if (secondCharWordList == null) {
                    secondCharWordList = new ArrayList<FuzzySearchToken>();
                }
                secondCharWordList.add(fuzzySearchToken);
                fuzzyIndex.put(secondCharacter, secondCharWordList);
            }
            ++i;
        }
        return fuzzyIndex;
    }

    public static ArrayList<HashMap> getFuzzyMatches(String query, Map<String, List<FuzzySearchToken>> fuzzyIndex) {
        ArrayList<HashMap> resultArray = new ArrayList<HashMap>();
        if (fuzzyIndex != null) {
            HashMap<String, ArrayList<String>> faqIdsWithKeywords = new HashMap<String, ArrayList<String>>();
            for (String token : HSSearch.generateTokens(HSSearch.sanitize(query))) {
                String rootChar = token.substring(0, 1);
                ArrayList<String> neighbourChars = new ArrayList<String>(HSSearch.getNeighbourCharacters(rootChar));
                neighbourChars.add(rootChar);
                for (String character : neighbourChars) {
                    ArrayList wordsList = (ArrayList)fuzzyIndex.get(character);
                    if (wordsList == null) continue;
                    for (FuzzySearchToken tokenFromIndex : wordsList) {
                        String wordToken = tokenFromIndex.word;
                        float wordDistance = HSSearch.calculateWordDistance(wordToken, token);
                        if (!((double)wordDistance > 0.7)) continue;
                        String id2 = tokenFromIndex.docId;
                        ArrayList<String> matchWordList = (ArrayList<String>)faqIdsWithKeywords.get(id2);
                        if (matchWordList == null) {
                            matchWordList = new ArrayList<String>();
                        }
                        matchWordList.add(wordToken);
                        faqIdsWithKeywords.put(id2, matchWordList);
                    }
                }
            }
            Set docIds = faqIdsWithKeywords.keySet();
            for (String docId : docIds) {
                HashMap<String, String> docIdTermsMap = new HashMap<String, String>();
                docIdTermsMap.put("f", docId);
                docIdTermsMap.put("t", (String)faqIdsWithKeywords.get(docId));
                resultArray.add(docIdTermsMap);
            }
        }
        return resultArray;
    }

    private static List<String> getNeighbourCharacters(String inputCharacter) {
        HashMap<String, String[]> characterTable = HSSearch.getCharacterTable();
        if (characterTable != null && characterTable.containsKey(inputCharacter)) {
            return Arrays.asList((Object[])characterTable.get(inputCharacter));
        }
        return new ArrayList<String>();
    }

    static HashMap<String, String[]> getCharacterTable() {
        if (characterTable == null) {
            characterTable = new HashMap();
            characterTable.put("a", new String[]{"q", "w", "s", "z"});
            characterTable.put("b", new String[]{"v", "h", "n"});
            characterTable.put("c", new String[]{"x", "f", "v"});
            characterTable.put("d", new String[]{"s", "z", "x"});
            characterTable.put("e", new String[]{"w", "s", "d", "r"});
            characterTable.put("f", new String[]{"d", "g", "c", "x"});
            characterTable.put("g", new String[]{"h", "f", "v", "b"});
            characterTable.put("h", new String[]{"g", "j", "b", "n"});
            characterTable.put("i", new String[]{"u", "o", "k", "j"});
            characterTable.put("j", new String[]{"m", "n", "h", "k"});
            characterTable.put("k", new String[]{"j", "l", "m"});
            characterTable.put("l", new String[]{"k", "p", "m"});
            characterTable.put("m", new String[]{"n", "b", "l"});
            characterTable.put("n", new String[]{"b", "j", "m"});
            characterTable.put("o", new String[]{"l", "k", "p"});
            characterTable.put("p", new String[]{"l", "o"});
            characterTable.put("q", new String[]{"w", "a"});
            characterTable.put("r", new String[]{"s", "d", "e", "f"});
            characterTable.put("s", new String[]{"a", "z", "d"});
            characterTable.put("t", new String[]{"r", "f", "g", "y"});
            characterTable.put("u", new String[]{"j", "h", "i", "y"});
            characterTable.put("v", new String[]{"c", "g", "b"});
            characterTable.put("w", new String[]{"q", "a", "s"});
            characterTable.put("x", new String[]{"z", "s", "c"});
            characterTable.put("y", new String[]{"g", "h", "t", "u"});
            characterTable.put("z", new String[]{"a", "s", "x"});
        }
        return characterTable;
    }

    static float calculateWordDistance(String originalString, String comparisionString) {
        originalString = originalString.trim();
        comparisionString = comparisionString.trim();
        originalString = originalString.toLowerCase();
        comparisionString = comparisionString.toLowerCase();
        int n = originalString.length();
        int m = comparisionString.length();
        if (n++ != 0 && m++ != 0) {
            int k;
            int[] d = new int[n * m];
            for (k = 0; k < n; ++k) {
                d[k] = k;
            }
            for (k = 0; k < m; ++k) {
                d[k * n] = k;
            }
            for (int i = 1; i < n; ++i) {
                for (int j = 1; j < m; ++j) {
                    int cost = originalString.charAt(i - 1) == comparisionString.charAt(j - 1) ? 0 : 1;
                    d[j * n + i] = HSSearch.smallestOf(d[(j - 1) * n + i] + 1, d[j * n + i - 1] + 1, d[(j - 1) * n + i - 1] + cost);
                    if (i <= 1 || j <= 1 || originalString.charAt(i - 1) != comparisionString.charAt(j - 2) || originalString.charAt(i - 2) != comparisionString.charAt(j - 1)) continue;
                    d[j * n + i] = HSSearch.smallestOf(d[j * n + i], d[(j - 2) * n + i - 2] + cost);
                }
            }
            int distance = d[n * m - 1];
            int maxLength = n > m ? n : m;
            return 1.0f - (float)distance / (float)maxLength;
        }
        return 0.0f;
    }

    private static int smallestOf(int a, int b, int c) {
        int min = a;
        if (b < min) {
            min = b;
        }
        if (c < min) {
            min = c;
        }
        return min;
    }

    private static int smallestOf(int a, int b) {
        int min = a;
        if (b < min) {
            min = b;
        }
        return min;
    }

    static {
        patternGenerateToken = Pattern.compile("[a-zA-Z0-9]+");
    }

    public static enum HS_SEARCH_OPTIONS {
        FULL_SEARCH,
        METAPHONE_SEARCH,
        KEYWORD_SEARCH;

    }
}

