/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.adapters;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.support.flows.Flow;
import java.util.List;

public class FlowListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<Flow> flows;
    private View.OnClickListener onClickListener;

    public FlowListAdapter(List<Flow> flows, View.OnClickListener onClickListener) {
        this.flows = flows;
        this.onClickListener = onClickListener;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        TextView textView = (TextView)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.hs__simple_list_item_1, parent, false);
        textView.setOnClickListener(this.onClickListener);
        return new ViewHolder(textView);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        Flow flow = this.flows.get(position);
        int labelResId = flow.getLabelResId();
        String label = labelResId != 0 ? holder.textView.getResources().getString(flow.getLabelResId()) : flow.getLabel();
        holder.textView.setText((CharSequence)label);
        holder.textView.setTag((Object)position);
    }

    public int getItemCount() {
        return this.flows.size();
    }

    protected static class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView textView;

        public ViewHolder(TextView textView) {
            super((View)textView);
            this.textView = textView;
        }
    }
}

