/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.compositions;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.helpshift.R;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.support.Faq;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.HSApiData;
import com.helpshift.support.Section;
import com.helpshift.support.constants.GetSectionsCallBackStatus;
import com.helpshift.support.contracts.FaqFlowViewParent;
import com.helpshift.support.contracts.FaqFragmentListener;
import com.helpshift.support.fragments.FaqFlowFragment;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.fragments.QuestionListFragment;
import com.helpshift.support.fragments.SectionListFragment;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.util.FragmentUtil;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;

public class FaqFragment
extends MainFragment
implements FaqFlowViewParent {
    private static final String TAG = "Helpshift_FaqFragment";
    int sectionsSize = 0;
    private FaqTagFilter faqTagFilter;
    private HSApiData data;
    boolean isDataUpdatePending;

    public static FaqFragment newInstance(Bundle bundle) {
        FaqFragment faqFragment = new FaqFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    public FaqFragmentListener getFaqFlowListener() {
        return ((FaqFlowViewParent)this.getParentFragment()).getFaqFlowListener();
    }

    void updateFragment(FaqFragment faqFragment, ArrayList<Section> sections) {
        Fragment previous = faqFragment.getRetainedChildFragmentManager().findFragmentById(R.id.faq_fragment_container);
        if (previous != null && !this.isDataUpdatePending) {
            return;
        }
        if ((sections = faqFragment.data.getPopulatedSections(sections, faqFragment.faqTagFilter)).size() == 1) {
            Bundle bundle = new Bundle();
            bundle.putString("sectionPublishId", sections.get(0).getPublishId());
            bundle.putSerializable("withTagsMatching", this.getArguments().getSerializable("withTagsMatching"));
            QuestionListFragment questionListFragment = QuestionListFragment.newInstance(bundle);
            try {
                FragmentUtil.startFragment(faqFragment.getRetainedChildFragmentManager(), R.id.faq_fragment_container, questionListFragment, null, null, false, this.isDataUpdatePending);
                this.isDataUpdatePending = false;
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            Bundle bundle = new Bundle();
            bundle.putParcelableArrayList("sections", sections);
            bundle.putSerializable("withTagsMatching", this.getArguments().getSerializable("withTagsMatching"));
            SectionListFragment sectionListFragment = SectionListFragment.newInstance(bundle);
            try {
                FragmentUtil.startFragment(faqFragment.getRetainedChildFragmentManager(), R.id.faq_fragment_container, sectionListFragment, null, null, false, this.isDataUpdatePending);
                this.isDataUpdatePending = false;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.sendFaqLoadedEvent();
    }

    private void sendFaqLoadedEvent() {
        SupportFragment supportFragment = FragmentUtil.getSupportFragment(this);
        if (supportFragment != null) {
            supportFragment.onFaqsLoaded();
        }
    }

    public void updateFaqLoadingUI(int state) {
        FaqFlowFragment faqFlowFragment = (FaqFlowFragment)this.getParentFragment();
        SupportFragment supportFragment = null;
        if (faqFlowFragment != null) {
            supportFragment = (SupportFragment)faqFlowFragment.getParentFragment();
        }
        if (supportFragment != null) {
            if (state == 1) {
                faqFlowFragment.showVerticalDivider(true);
                faqFlowFragment.updateSelectQuestionUI();
            } else {
                faqFlowFragment.showVerticalDivider(false);
                faqFlowFragment.updateSelectQuestionUI(false);
            }
            supportFragment.updateFaqLoadingUI(state);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = this.getArguments();
        if (extras != null) {
            this.faqTagFilter = (FaqTagFilter)extras.getSerializable("withTagsMatching");
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__faq_fragment, container, false);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.data = new HSApiData(context);
    }

    public void onResume() {
        super.onResume();
        this.setToolbarTitle(this.getString(R.string.hs__help_header));
        if (this.sectionsSize == 0) {
            this.updateFaqLoadingUI(0);
        }
        this.data.getSections(new Success(this), new Failure(this), this.faqTagFilter);
        if (!this.isChangingConfigurations()) {
            HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(AnalyticsEventType.SUPPORT_LAUNCH);
        }
    }

    @Override
    public boolean shouldRefreshMenu() {
        return true;
    }

    public void onDestroyView() {
        SnackbarUtil.hideSnackbar(this.getView());
        super.onDestroyView();
    }

    @Override
    public void onStop() {
        super.onStop();
        this.updateFaqLoadingUI(1);
    }

    public void retryGetSections() {
        if (this.sectionsSize == 0) {
            this.updateFaqLoadingUI(0);
        }
        this.data.getSections(new Success(this), new Failure(this), this.faqTagFilter);
    }

    ArrayList<Section> removeEmptySections(ArrayList<Section> sections) {
        ArrayList<Section> nonEmptySections = new ArrayList<Section>();
        for (Section section : sections) {
            ArrayList<Faq> faqsForSection = this.data.getFaqsForSection(section.getPublishId(), this.faqTagFilter);
            if (faqsForSection == null || faqsForSection.isEmpty()) continue;
            nonEmptySections.add(section);
        }
        return nonEmptySections;
    }

    private static class Failure
    extends Handler {
        private final WeakReference<FaqFragment> faqFragmentWeakReference;
        private final int defaultNetworkStatusErrorCode;

        public Failure(FaqFragment fragment) {
            this.faqFragmentWeakReference = new WeakReference<FaqFragment>(fragment);
            this.defaultNetworkStatusErrorCode = 42;
        }

        public void handleMessage(Message msg) {
            FaqFragment faqFragment = (FaqFragment)this.faqFragmentWeakReference.get();
            if (faqFragment != null && faqFragment.getHost() != null && !faqFragment.isDetached()) {
                Object networkStatus;
                int status = this.defaultNetworkStatusErrorCode;
                if (msg.obj instanceof HashMap && (networkStatus = ((HashMap)msg.obj).get("status")) instanceof Integer) {
                    status = (Integer)networkStatus;
                }
                SnackbarUtil.showErrorSnackbar(status, faqFragment.getView());
                if (faqFragment.sectionsSize == 0) {
                    faqFragment.updateFaqLoadingUI(3);
                } else {
                    faqFragment.updateFaqLoadingUI(1);
                }
            }
        }
    }

    private static class Success
    extends Handler {
        private final WeakReference<FaqFragment> faqFragmentWeakReference;

        public Success(FaqFragment fragment) {
            this.faqFragmentWeakReference = new WeakReference<FaqFragment>(fragment);
        }

        public void handleMessage(Message msg) {
            FaqFragment faqFragment = (FaqFragment)this.faqFragmentWeakReference.get();
            if (faqFragment != null && faqFragment.getHost() != null && !faqFragment.isDetached()) {
                ArrayList<Section> sections = (ArrayList<Section>)msg.obj;
                int status = msg.what;
                if (sections != null) {
                    sections = faqFragment.removeEmptySections(sections);
                    faqFragment.sectionsSize = sections.size();
                }
                if (status == GetSectionsCallBackStatus.DATABASE_SUCCESS) {
                    if (faqFragment.sectionsSize != 0) {
                        faqFragment.updateFaqLoadingUI(1);
                        faqFragment.updateFragment(faqFragment, sections);
                    }
                } else if (status == GetSectionsCallBackStatus.API_SUCCESS_NEW_DATA) {
                    if (faqFragment.sectionsSize == 0) {
                        faqFragment.updateFaqLoadingUI(2);
                    } else {
                        faqFragment.isDataUpdatePending = true;
                        faqFragment.updateFaqLoadingUI(1);
                        faqFragment.updateFragment(faqFragment, sections);
                    }
                } else if (status == GetSectionsCallBackStatus.API_SUCCESS_NO_NEW_DATA && faqFragment.sectionsSize == 0) {
                    faqFragment.updateFaqLoadingUI(2);
                }
                HSLogger.d(FaqFragment.TAG, "Faq loaded with " + faqFragment.sectionsSize + " sections");
            }
        }
    }

    public static class FaqLoadingStatus {
        public static final int IN_PROGRESS = 0;
        public static final int HIDE = 1;
        public static final int NO_FAQS = 2;
        public static final int ERROR = 3;
    }
}

