/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.controllers;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.widget.SearchView;
import android.text.TextUtils;
import android.view.MenuItem;
import com.helpshift.R;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.support.compositions.FaqFragment;
import com.helpshift.support.compositions.SectionPagerFragment;
import com.helpshift.support.contracts.FaqFlowView;
import com.helpshift.support.contracts.FaqFragmentListener;
import com.helpshift.support.fragments.QuestionListFragment;
import com.helpshift.support.fragments.SearchFragment;
import com.helpshift.support.fragments.SingleQuestionFragment;
import com.helpshift.support.util.FragmentUtil;
import com.helpshift.util.HelpshiftConnectionUtil;
import com.helpshift.util.HelpshiftContext;
import java.util.ArrayList;
import java.util.HashMap;

public class FaqFlowController
implements FaqFragmentListener,
MenuItemCompat.OnActionExpandListener,
MenuItem.OnActionExpandListener,
SearchView.OnQueryTextListener {
    private final String KEY_FAQ_CONTROLLER_STARTED_STATE = "key_faq_controller_state";
    private final FaqFlowView faqFlowView;
    private FragmentManager fragmentManager;
    private final boolean isScreenLarge;
    private final Bundle bundle;
    private boolean isControllerStarted;
    private boolean retainSearchFragmentState;
    private String currentQuery = "";
    private String lastQuery = "";

    public FaqFlowController(FaqFlowView faqFlowView, Context context, FragmentManager fragmentManager, Bundle bundle) {
        this.faqFlowView = faqFlowView;
        this.isScreenLarge = context.getResources().getBoolean(R.bool.is_screen_large);
        this.fragmentManager = fragmentManager;
        this.bundle = bundle;
    }

    public void onFragmentManagerUpdate(FragmentManager fragmentManager) {
        this.fragmentManager = fragmentManager;
    }

    public void start() {
        if (!this.isControllerStarted) {
            int supportMode = this.bundle.getInt("support_mode", 0);
            switch (supportMode) {
                case 2: {
                    this.startQuestionListFragment();
                    break;
                }
                case 3: {
                    this.startSingleQuestionFragment();
                    break;
                }
                default: {
                    this.startFaqFragment();
                }
            }
        }
        this.isControllerStarted = true;
    }

    private void startFaqFragment() {
        FaqFragment faqFragment = FaqFragment.newInstance(this.bundle);
        FragmentUtil.startFragmentWithoutBackStack(this.fragmentManager, R.id.list_fragment_container, faqFragment, null, true);
    }

    private void startQuestionListFragment() {
        QuestionListFragment questionListFragment = QuestionListFragment.newInstance(this.bundle);
        FragmentUtil.startFragmentWithoutBackStack(this.fragmentManager, R.id.list_fragment_container, questionListFragment, null, false);
    }

    private void startSingleQuestionFragment() {
        int singleQuestionContainer = R.id.list_fragment_container;
        if (this.isScreenLarge) {
            singleQuestionContainer = R.id.single_question_container;
        }
        this.faqFlowView.getSupportFragment().getSupportController().setSearchPerformed(true);
        SingleQuestionFragment singleQuestionFragment = SingleQuestionFragment.newInstance(this.bundle, 1, this.isScreenLarge);
        FragmentUtil.startFragmentWithoutBackStack(this.fragmentManager, singleQuestionContainer, singleQuestionFragment, null, false);
    }

    public void setRetainSearchFragmentState(boolean retainSearchFragmentState) {
        this.retainSearchFragmentState = retainSearchFragmentState;
    }

    @Override
    public void onSectionSelected(Bundle bundle) {
        if (this.isScreenLarge) {
            QuestionListFragment questionListFragment = QuestionListFragment.newInstance(bundle);
            FragmentUtil.startFragmentWithBackStack(this.fragmentManager, R.id.list_fragment_container, questionListFragment, null, false);
        } else {
            SectionPagerFragment sectionPagerFragment = SectionPagerFragment.newInstance(bundle);
            FragmentUtil.startFragmentWithBackStack(this.fragmentManager, R.id.list_fragment_container, sectionPagerFragment, null, false);
        }
    }

    @Override
    public void onQuestionSelected(String questionPublishId, ArrayList<String> searchTerms) {
        this.performedSearch();
        this.faqFlowView.getSupportFragment().getSupportController().setSearchPerformed(true);
        Bundle bundle = new Bundle();
        bundle.putString("questionPublishId", questionPublishId);
        bundle.putStringArrayList("searchTerms", searchTerms);
        if (this.isScreenLarge) {
            int singleQuestionFragmentResourceId = R.id.details_fragment_container;
            FragmentUtil.startFragmentWithoutBackStack(this.fragmentManager, singleQuestionFragmentResourceId, SingleQuestionFragment.newInstance(bundle, 1, false), null, false);
        } else {
            int singleQuestionFragmentResourceId = R.id.list_fragment_container;
            FragmentUtil.startFragmentWithBackStack(this.fragmentManager, singleQuestionFragmentResourceId, SingleQuestionFragment.newInstance(bundle, 1, false), null, false);
        }
    }

    @Override
    public void onContactUsClicked(String query) {
        this.setRetainSearchFragmentState(true);
        this.performedSearch();
        this.faqFlowView.getSupportFragment().getSupportController().onContactUsClicked(query);
    }

    public boolean onMenuItemActionExpand(MenuItem item) {
        SearchFragment searchFragment = (SearchFragment)this.fragmentManager.findFragmentByTag("Helpshift_SearchFrag");
        if (searchFragment == null) {
            searchFragment = SearchFragment.newInstance(this.bundle);
            FragmentUtil.startFragmentWithBackStack(this.fragmentManager, R.id.list_fragment_container, searchFragment, "Helpshift_SearchFrag", false);
        }
        return true;
    }

    public boolean onMenuItemActionCollapse(MenuItem item) {
        this.performedSearch();
        if (!this.retainSearchFragmentState) {
            this.lastQuery = "";
            this.currentQuery = "";
            FragmentUtil.popBackStack(this.fragmentManager, SearchFragment.class.getName());
        }
        return true;
    }

    public boolean onQueryTextSubmit(String query) {
        return false;
    }

    public boolean onQueryTextChange(String newText) {
        if (TextUtils.isEmpty((CharSequence)newText) && this.currentQuery.length() > 2) {
            this.performedSearch();
        }
        this.currentQuery = newText;
        return this.onQuery(newText);
    }

    private boolean onQuery(String query) {
        SearchFragment searchFragment;
        boolean retValue = false;
        if (!this.retainSearchFragmentState && (searchFragment = (SearchFragment)this.fragmentManager.findFragmentByTag("Helpshift_SearchFrag")) != null) {
            searchFragment.onQuery(query, this.bundle.getString("sectionPublishId"));
            retValue = true;
        }
        return retValue;
    }

    public void performedSearch() {
        if (!TextUtils.isEmpty((CharSequence)this.currentQuery.trim()) && !this.lastQuery.equals(this.currentQuery)) {
            int searchResultCount;
            this.faqFlowView.getSupportFragment().getSupportController().setSearchPerformed(true);
            this.bundle.putBoolean("search_performed", true);
            SearchFragment searchFragment = (SearchFragment)this.fragmentManager.findFragmentByTag("Helpshift_SearchFrag");
            if (searchFragment != null && (searchResultCount = searchFragment.getNumberOfSearchResults()) >= 0) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("s", this.currentQuery);
                data.put("n", searchResultCount);
                data.put("nt", HelpshiftConnectionUtil.isOnline(HelpshiftContext.getApplicationContext()));
                HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(AnalyticsEventType.PERFORMED_SEARCH, data);
                this.lastQuery = this.currentQuery;
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putBoolean("key_faq_controller_state", this.isControllerStarted);
    }

    public void onViewStateRestored(Bundle savedInstanceState) {
        if (!this.isControllerStarted && savedInstanceState.containsKey("key_faq_controller_state")) {
            this.isControllerStarted = savedInstanceState.getBoolean("key_faq_controller_state");
        }
    }
}

