/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.controllers;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import com.helpshift.R;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.dto.ConversationDetailDTO;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.support.contracts.ScreenshotPreviewListener;
import com.helpshift.support.contracts.SearchResultListener;
import com.helpshift.support.contracts.SupportScreenView;
import com.helpshift.support.conversations.BaseConversationFragment;
import com.helpshift.support.conversations.ConversationFragment;
import com.helpshift.support.conversations.NewConversationFragment;
import com.helpshift.support.flows.CustomContactUsFlowListHolder;
import com.helpshift.support.flows.DynamicFormFlowListHolder;
import com.helpshift.support.flows.Flow;
import com.helpshift.support.fragments.ConversationInfoFragment;
import com.helpshift.support.fragments.DynamicFormFragment;
import com.helpshift.support.fragments.FaqFlowFragment;
import com.helpshift.support.fragments.ScreenshotPreviewFragment;
import com.helpshift.support.fragments.SearchResultFragment;
import com.helpshift.support.fragments.SingleQuestionFragment;
import com.helpshift.support.util.FragmentUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SupportController
implements SearchResultListener,
ScreenshotPreviewListener {
    private final String KEY_SUPPORT_CONTROLLER_STARTED_STATE = "key_support_controller_started";
    private final String KEY_CONVERSATION_BUNDLE = "key_conversation_bundle";
    private final String KEY_CONVERSATION_ADD_TO_BACK_STACK = "key_conversation_add_to_back_stack";
    private final Context context;
    private final SupportScreenView supportScreenView;
    private FragmentManager fragmentManager;
    private final Bundle bundle;
    private Bundle conversationBundle;
    private boolean isControllerStarted;
    private int supportMode;
    private boolean searchPerformed = false;
    private boolean conversationAddToBackStack;
    private String sourceSearchQuery;
    private static final String TAG = "Helpshift_SupportContr";

    public SupportController(Context context, SupportScreenView supportScreenView, FragmentManager fragmentManager, Bundle bundle) {
        this.context = context;
        this.supportScreenView = supportScreenView;
        this.fragmentManager = fragmentManager;
        this.bundle = bundle;
    }

    public void onFragmentManagerUpdate(FragmentManager fragmentManager) {
        this.fragmentManager = fragmentManager;
    }

    public void setSearchPerformed(boolean searchPerformed) {
        this.searchPerformed = searchPerformed;
    }

    public void start() {
        if (!this.isControllerStarted) {
            this.supportMode = this.bundle.getInt("support_mode", 0);
            switch (this.supportMode) {
                case 1: {
                    this.startConversationFlow(this.bundle, false);
                    break;
                }
                case 4: {
                    this.startDynamicForm(DynamicFormFlowListHolder.getFlowList(), false);
                    break;
                }
                default: {
                    this.startFaqFlow(this.bundle, false, CustomContactUsFlowListHolder.getFlowList());
                }
            }
        }
        this.isControllerStarted = true;
    }

    private void replaceConversationFlow(Bundle newIntentData) {
        Long conversationIdFromNotification = newIntentData.getLong("conversationIdInPush");
        Long conversationIdOnUI = this.conversationBundle != null ? Long.valueOf(this.conversationBundle.getLong("issueId")) : null;
        boolean replaceCurrentConversation = !conversationIdFromNotification.equals(conversationIdOnUI);
        boolean conversationFound = false;
        boolean shouldStartConversationFlow = false;
        List activeFragments = this.fragmentManager.getFragments();
        if (replaceCurrentConversation) {
            Fragment convInfoFragment;
            Fragment conversationFragment;
            for (int i = activeFragments.size() - 1; i >= 0; --i) {
                Fragment activeFrag = (Fragment)activeFragments.get(i);
                if (!(activeFrag instanceof ScreenshotPreviewFragment) && !(activeFrag instanceof BaseConversationFragment) && !(activeFrag instanceof ConversationInfoFragment)) continue;
                if (i == 0) {
                    FragmentUtil.removeFragment(this.fragmentManager, activeFrag);
                    continue;
                }
                FragmentUtil.popBackStackImmediate(this.fragmentManager, activeFrag.getClass().getName());
            }
            while ((conversationFragment = this.fragmentManager.findFragmentByTag("HSConversationFragment")) != null) {
                conversationFound = true;
                FragmentUtil.popBackStackImmediate(this.fragmentManager, conversationFragment.getClass().getName());
            }
            while ((convInfoFragment = this.fragmentManager.findFragmentByTag("HSConversationInfoFragment")) != null) {
                FragmentUtil.popBackStackImmediate(this.fragmentManager, convInfoFragment.getClass().getName());
            }
            if (!conversationFound) {
                this.conversationAddToBackStack = true;
            }
            shouldStartConversationFlow = true;
        } else if (activeFragments.size() > 0) {
            Fragment topMostFragment = (Fragment)activeFragments.get(activeFragments.size() - 1);
            if (topMostFragment instanceof ScreenshotPreviewFragment) {
                return;
            }
            if (topMostFragment instanceof ConversationInfoFragment) {
                FragmentUtil.removeFragment(this.fragmentManager, topMostFragment);
                FragmentUtil.popBackStackImmediate(this.fragmentManager, topMostFragment.getClass().getName());
            } else if (!(topMostFragment instanceof BaseConversationFragment)) {
                shouldStartConversationFlow = true;
            }
        } else {
            shouldStartConversationFlow = true;
        }
        if (shouldStartConversationFlow) {
            this.conversationBundle = newIntentData;
            this.startConversationFlow();
        }
    }

    public void startConversationFlow(Bundle bundle, boolean addToBackStack) {
        this.conversationAddToBackStack = addToBackStack;
        this.conversationBundle = bundle;
        this.startConversationFlow();
    }

    public void startConversationFlow() {
        long conversationIdFromNotification;
        if (this.conversationBundle == null) {
            this.conversationBundle = this.bundle;
        }
        if ((conversationIdFromNotification = this.conversationBundle.getLong("conversationIdInPush", 0L)) != 0L) {
            this.conversationBundle.remove("conversationIdInPush");
            boolean shouldOpenConversation = HelpshiftContext.getCoreApi().getConversationInboxDM().shouldOpenConversationFromNotification(conversationIdFromNotification);
            if (shouldOpenConversation) {
                this.showConversationFragment(conversationIdFromNotification);
                return;
            }
        }
        ConversationDM activeConversation = HelpshiftContext.getCoreApi().getActiveConversation();
        Long activeConversationId = null;
        if (activeConversation != null) {
            activeConversationId = activeConversation.localId;
        }
        if (activeConversationId == null) {
            List<Flow> flowList = CustomContactUsFlowListHolder.getFlowList();
            if (flowList == null || flowList.isEmpty()) {
                this.showNewConversationFragment();
            } else {
                String backStackName;
                int index = this.fragmentManager.getBackStackEntryCount() - 1;
                FragmentManager.BackStackEntry backEntry = this.getFragmentManager().getBackStackEntryAt(index);
                if (backEntry != null && (backStackName = backEntry.getName()) != null && backStackName.equals(ConversationFragment.class.getName())) {
                    FragmentUtil.popBackStackImmediate(this.fragmentManager, backStackName);
                }
                this.startDynamicForm(flowList, true);
            }
        } else {
            this.showConversationFragment(activeConversationId);
        }
    }

    public void startFaqFlow(Bundle bundle, boolean addToBackStack, List<Flow> customContactUsFlows) {
        FaqFlowFragment faqFlowFragment = FaqFlowFragment.newInstance(bundle, customContactUsFlows);
        String backStackName = null;
        if (addToBackStack) {
            backStackName = FaqFlowFragment.class.getName();
        }
        FragmentUtil.startFragment(this.fragmentManager, R.id.flow_fragment_container, faqFlowFragment, "Helpshift_FaqFlowFrag", backStackName, false, false);
    }

    private void showNewConversationFragment() {
        HSLogger.d(TAG, "Starting new conversation fragment");
        this.conversationBundle.putBoolean("search_performed", this.searchPerformed);
        this.conversationBundle.putString("source_search_query", this.sourceSearchQuery);
        NewConversationFragment newConversationFragment = NewConversationFragment.newInstance(this.conversationBundle);
        String backStackName = null;
        if (this.conversationAddToBackStack) {
            backStackName = newConversationFragment.getClass().getName();
            FragmentUtil.popBackStackImmediate(this.fragmentManager, ConversationFragment.class.getName());
        }
        FragmentUtil.startFragment(this.fragmentManager, R.id.flow_fragment_container, newConversationFragment, "HSNewConversationFragment", backStackName, false, false);
    }

    private void showConversationFragment(Long activeConversationId) {
        HSLogger.d(TAG, "Starting conversation fragment: " + activeConversationId);
        this.conversationBundle.putLong("issueId", activeConversationId.longValue());
        ConversationFragment conversationFragment = ConversationFragment.newInstance(this.conversationBundle);
        String backStackName = null;
        if (this.conversationAddToBackStack) {
            backStackName = conversationFragment.getClass().getName();
            FragmentUtil.popBackStackImmediate(this.fragmentManager, NewConversationFragment.class.getName());
        }
        FragmentUtil.startFragment(this.fragmentManager, R.id.flow_fragment_container, conversationFragment, "HSConversationFragment", backStackName, false, false);
    }

    public void showConversationSearchResultFragment(Bundle bundle) {
        FragmentUtil.startFragmentWithBackStack(this.fragmentManager, R.id.flow_fragment_container, SearchResultFragment.newInstance(bundle, this), "HSSearchResultFragment", false);
    }

    public void startScreenshotPreviewFragment(ImagePickerFile imagePickerFile, Bundle bundle, ScreenshotPreviewFragment.LaunchSource launchSource) {
        ScreenshotPreviewFragment screenshotPreviewFragment = FragmentUtil.getScreenshotPreviewFragment(this.getFragmentManager());
        if (screenshotPreviewFragment == null) {
            screenshotPreviewFragment = ScreenshotPreviewFragment.newInstance(this);
            FragmentUtil.startFragmentWithBackStack(this.getFragmentManager(), R.id.flow_fragment_container, screenshotPreviewFragment, "ScreenshotPreviewFragment", false);
        }
        screenshotPreviewFragment.setParams(bundle, imagePickerFile, launchSource);
    }

    public void showConversationInfoScreen(String issueId, String publishId) {
        Bundle bundle = new Bundle();
        bundle.putString("issue_publish_id", publishId);
        ConversationInfoFragment conversationInfoFragment = ConversationInfoFragment.newInstance(bundle);
        FragmentUtil.startFragmentWithBackStack(this.fragmentManager, R.id.flow_fragment_container, conversationInfoFragment, "HSConversationInfoFragment", false);
    }

    public void startDynamicForm(List<Flow> flowList, boolean addToBackStack) {
        DynamicFormFragment dynamicFormFragment = DynamicFormFragment.newInstance(this.bundle, flowList, this);
        String backStackName = null;
        if (addToBackStack) {
            backStackName = DynamicFormFragment.class.getName();
        }
        FragmentUtil.startFragment(this.fragmentManager, R.id.flow_fragment_container, dynamicFormFragment, "HSDynamicFormFragment", backStackName, false, false);
    }

    public void startDynamicForm(String title, List<Flow> flowList, boolean addToBackStack) {
        if (this.bundle != null) {
            this.bundle.putString("flow_title", title);
        }
        this.startDynamicForm(flowList, addToBackStack);
    }

    public void startDynamicForm(int titleResId, List<Flow> flowList, boolean addToBackStack) {
        if (this.bundle != null && titleResId != 0) {
            this.bundle.putString("flow_title", this.context.getResources().getString(titleResId));
        }
        this.startDynamicForm(flowList, addToBackStack);
    }

    public int getSupportMode() {
        return this.supportMode;
    }

    public FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    public void onContactUsClicked(String query) {
        if (this.handleCustomContactUsFlows()) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)query)) {
            this.sourceSearchQuery = query;
        }
        this.bundle.putString("chatLaunchSource", "support");
        this.startConversationFlow(this.bundle, true);
    }

    private boolean handleCustomContactUsFlows() {
        List<Flow> customContactUsFlows;
        FaqFlowFragment faqFlowFragment;
        ConversationDM activeConversation = HelpshiftContext.getCoreApi().getActiveConversation();
        if (activeConversation == null && (faqFlowFragment = FragmentUtil.getFaqFlowFragment(this.fragmentManager)) != null && (customContactUsFlows = faqFlowFragment.getCustomContactUsFlows()) != null && !customContactUsFlows.isEmpty()) {
            this.startDynamicForm(customContactUsFlows, true);
            return true;
        }
        return false;
    }

    public void actionDone() {
        this.sendTicketAvoidedEvent();
        Long profileLocalId = HelpshiftContext.getCoreApi().getAccountManagerDM().getProfileDM().localId;
        ConversationDetailDTO descriptionDto = new ConversationDetailDTO("", System.nanoTime(), 0);
        HelpshiftContext.getPlatform().getConversationInboxDAO().saveDescriptionDetail(profileLocalId, descriptionDto);
        HelpshiftContext.getPlatform().getConversationInboxDAO().saveImageAttachment(profileLocalId, null);
        if (this.getSupportMode() == 1) {
            this.supportScreenView.exitSdkSession();
        } else {
            FragmentUtil.popBackStackImmediate(this.getFragmentManager(), NewConversationFragment.class.getName());
        }
    }

    private void sendTicketAvoidedEvent() {
        String questionId;
        SingleQuestionFragment singleQuestionFragment = FragmentUtil.getSingleQuestionFragment(this.fragmentManager);
        if (singleQuestionFragment != null && !TextUtils.isEmpty((CharSequence)(questionId = singleQuestionFragment.getQuestionId()))) {
            HashMap<String, Object> eventData = new HashMap<String, Object>();
            eventData.put("id", questionId);
            Long profileLocalId = HelpshiftContext.getCoreApi().getAccountManagerDM().getProfileDM().localId;
            eventData.put("str", HelpshiftContext.getPlatform().getConversationInboxDAO().getDescriptionDetail((long)profileLocalId.longValue()).title);
            HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(AnalyticsEventType.TICKET_AVOIDED, eventData);
        }
    }

    @Override
    public void onQuestionSelected(String questionPublishId, ArrayList<String> searchTerms) {
        boolean isScreenLarge = HelpshiftContext.getApplicationContext().getResources().getBoolean(R.bool.is_screen_large);
        Bundle bundle = new Bundle();
        bundle.putString("questionPublishId", questionPublishId);
        if (searchTerms != null) {
            bundle.putStringArrayList("searchTerms", searchTerms);
        }
        FragmentUtil.startFragmentWithBackStack(this.fragmentManager, R.id.flow_fragment_container, SingleQuestionFragment.newInstance(bundle, 2, isScreenLarge), null, false);
    }

    @Override
    public void sendAnyway() {
        HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(AnalyticsEventType.TICKET_AVOIDANCE_FAILED);
        FragmentUtil.popBackStackImmediate(this.getFragmentManager(), SearchResultFragment.class.getName());
        NewConversationFragment newConversationFragment = (NewConversationFragment)this.fragmentManager.findFragmentByTag("HSNewConversationFragment");
        if (newConversationFragment != null) {
            newConversationFragment.startNewConversation();
        }
    }

    @Override
    public void addScreenshot(ImagePickerFile imagePickerFile) {
        FragmentUtil.popBackStack(this.fragmentManager, ScreenshotPreviewFragment.class.getName());
        NewConversationFragment newConversationFragment = (NewConversationFragment)this.fragmentManager.findFragmentByTag("HSNewConversationFragment");
        if (newConversationFragment != null) {
            newConversationFragment.handleScreenshotAction(ScreenshotPreviewFragment.ScreenshotAction.ADD, imagePickerFile);
        }
    }

    @Override
    public void sendScreenshot(ImagePickerFile imagePickerFile, @Nullable String messageRefersId) {
        FragmentUtil.popBackStack(this.fragmentManager, ScreenshotPreviewFragment.class.getName());
        ConversationFragment conversationFragment = (ConversationFragment)this.fragmentManager.findFragmentByTag("HSConversationFragment");
        if (conversationFragment != null) {
            conversationFragment.handleScreenshotAction(ScreenshotPreviewFragment.ScreenshotAction.SEND, imagePickerFile, messageRefersId);
        }
    }

    @Override
    public void removeScreenshot() {
        FragmentUtil.popBackStack(this.fragmentManager, ScreenshotPreviewFragment.class.getName());
        NewConversationFragment newConversationFragment = (NewConversationFragment)this.fragmentManager.findFragmentByTag("HSNewConversationFragment");
        if (newConversationFragment != null) {
            newConversationFragment.handleScreenshotAction(ScreenshotPreviewFragment.ScreenshotAction.REMOVE, null);
        }
    }

    @Override
    public void changeScreenshot(Bundle extras) {
        this.supportScreenView.launchImagePicker(true, extras);
    }

    @Override
    public void removeScreenshotPreviewFragment() {
        FragmentUtil.popBackStack(this.fragmentManager, ScreenshotPreviewFragment.class.getName());
    }

    public void onNewIntent(Bundle data) {
        int supportMode = data.getInt("support_mode");
        switch (supportMode) {
            case 1: {
                this.replaceConversationFlow(data);
                break;
            }
            case 2: 
            case 3: {
                this.startFaqFlow(data, true, CustomContactUsFlowListHolder.getFlowList());
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putBoolean("key_support_controller_started", this.isControllerStarted);
        outState.putBundle("key_conversation_bundle", this.conversationBundle);
        outState.putBoolean("key_conversation_add_to_back_stack", this.conversationAddToBackStack);
    }

    public void onViewStateRestored(Bundle savedInstanceState) {
        if (this.isControllerStarted) {
            return;
        }
        if (savedInstanceState.containsKey("key_support_controller_started")) {
            this.isControllerStarted = savedInstanceState.containsKey("key_support_controller_started");
            this.supportMode = this.bundle.getInt("support_mode", 0);
            if (this.fragmentManager != null) {
                DynamicFormFragment dynamicFormFragment;
                SearchResultFragment searchResultFragment;
                ScreenshotPreviewFragment screenshotPreviewFragment = (ScreenshotPreviewFragment)this.fragmentManager.findFragmentByTag("ScreenshotPreviewFragment");
                if (screenshotPreviewFragment != null) {
                    screenshotPreviewFragment.setScreenshotPreviewListener(this);
                }
                if ((searchResultFragment = (SearchResultFragment)this.fragmentManager.findFragmentByTag("HSSearchResultFragment")) != null) {
                    searchResultFragment.setSearchResultListener(this);
                }
                if ((dynamicFormFragment = (DynamicFormFragment)this.fragmentManager.findFragmentByTag("HSDynamicFormFragment")) != null) {
                    dynamicFormFragment.setSupportController(this);
                }
            }
        }
        if (savedInstanceState.containsKey("key_conversation_bundle") && savedInstanceState.containsKey("key_conversation_add_to_back_stack")) {
            this.conversationBundle = savedInstanceState.getBundle("key_conversation_bundle");
            this.conversationAddToBackStack = savedInstanceState.getBoolean("key_conversation_add_to_back_stack");
        }
    }
}

