/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.Snackbar;
import android.view.MenuItem;
import android.view.View;
import com.helpshift.R;
import com.helpshift.support.controllers.SupportController;
import com.helpshift.support.fragments.IMenuItemEventListener;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.storage.IMAppSessionStorage;
import com.helpshift.support.util.AppSessionConstants;
import com.helpshift.support.util.KeyboardUtil;
import com.helpshift.support.util.PermissionUtil;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.views.HSSnackbar;

public abstract class BaseConversationFragment
extends MainFragment
implements MenuItem.OnMenuItemClickListener,
IMenuItemEventListener {
    private static final String TAG = "Helpshift_BaseConvFrag";
    public static final String CONVERSATION_LAUNCH_SOURCE = "chatLaunchSource";
    private Snackbar showRationaleSnackbar;
    private Snackbar permissionDeniedSnackbar;
    public static final int REQUEST_READ_STORAGE_PERMISSION_REQUEST_ID = 2;
    public static final int REQUEST_WRITE_STORAGE_PERMISSION_REQUEST_ID = 3;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getSupportFragment().resetNewMessageCount();
    }

    @Override
    public void onStart() {
        super.onStart();
        IMAppSessionStorage.getInstance().set("current_open_screen", this.getViewName());
    }

    public void onResume() {
        super.onResume();
        this.setToolbarTitle(this.getToolbarTitle());
    }

    protected abstract int getScreenshotMode();

    protected abstract AppSessionConstants.Screen getViewName();

    protected abstract String getToolbarTitle();

    @Override
    public boolean shouldRefreshMenu() {
        return true;
    }

    protected SupportFragment getSupportFragment() {
        return (SupportFragment)this.getParentFragment();
    }

    protected SupportController getSupportController() {
        return this.getSupportFragment().getSupportController();
    }

    public boolean onMenuItemClick(MenuItem item) {
        return false;
    }

    protected void requestWriteExternalStoragePermission(boolean isRequestable) {
        this.requestPermission(isRequestable, 3);
    }

    public void requestPermission(boolean isRequestable, int requestID) {
        String androidPermissionId = null;
        switch (requestID) {
            case 2: {
                androidPermissionId = "android.permission.READ_EXTERNAL_STORAGE";
                break;
            }
            case 3: {
                androidPermissionId = "android.permission.WRITE_EXTERNAL_STORAGE";
            }
        }
        if (isRequestable && androidPermissionId != null) {
            KeyboardUtil.hideKeyboard(this.getContext(), this.getView());
            this.showRationaleSnackbar = PermissionUtil.requestPermissions(this.getParentFragment(), new String[]{androidPermissionId}, requestID, this.getView());
        } else if (!this.isDetached()) {
            SnackbarUtil.showSnackbar(this.getView(), R.string.hs__permission_not_granted, -1);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        boolean isPermissionGranted = grantResults.length == 1 && grantResults[0] == 0;
        HSLogger.d(TAG, "onRequestPermissionsResult : request: " + requestCode + ", result: " + isPermissionGranted);
        if (isPermissionGranted) {
            this.onPermissionGranted(requestCode);
        } else {
            this.permissionDeniedSnackbar = HSSnackbar.make(this.getView(), R.string.hs__permission_denied_message, -1).setAction(R.string.hs__permission_denied_snackbar_action, new View.OnClickListener(){

                public void onClick(View v) {
                    PermissionUtil.showSettingsPage(BaseConversationFragment.this.getContext());
                }
            });
            this.permissionDeniedSnackbar.show();
        }
    }

    protected abstract void onPermissionGranted(int var1);

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getSupportFragment().registerToolbarMenuEventsListener(this);
    }

    public void onDestroyView() {
        SnackbarUtil.hideSnackbar(this.getView());
        this.getSupportFragment().unRegisterToolbarMenuEventsListener(this);
        super.onDestroyView();
    }

    @Override
    public void onPause() {
        if (this.showRationaleSnackbar != null && this.showRationaleSnackbar.isShown()) {
            this.showRationaleSnackbar.dismiss();
        }
        if (this.permissionDeniedSnackbar != null && this.permissionDeniedSnackbar.isShown()) {
            this.permissionDeniedSnackbar.dismiss();
        }
        super.onPause();
    }

    @Override
    public void onStop() {
        AppSessionConstants.Screen currentOpenScreen = (AppSessionConstants.Screen)IMAppSessionStorage.getInstance().get("current_open_screen");
        if (currentOpenScreen != null && currentOpenScreen.equals(this.getViewName())) {
            IMAppSessionStorage.getInstance().removeKey("current_open_screen");
        }
        this.setToolbarTitle(this.getString(R.string.hs__help_header));
        super.onStop();
    }
}

