/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations;

import android.app.DownloadManager;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.text.TextWatcher;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.platform.Device;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestScreenshotMessageDM;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.viewmodel.ConversationVM;
import com.helpshift.support.conversations.BaseConversationFragment;
import com.helpshift.support.conversations.ConversationFragmentRenderer;
import com.helpshift.support.conversations.ConversationFragmentRouter;
import com.helpshift.support.conversations.TextWatcherAdapter;
import com.helpshift.support.conversations.messages.MessagesAdapterClickListener;
import com.helpshift.support.fragments.HSMenuItemType;
import com.helpshift.support.fragments.IMenuItemEventListener;
import com.helpshift.support.fragments.ScreenshotPreviewFragment;
import com.helpshift.support.util.AppSessionConstants;
import com.helpshift.support.util.KeyboardUtil;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;

public class ConversationFragment
extends BaseConversationFragment
implements MessagesAdapterClickListener,
ConversationFragmentRouter,
IMenuItemEventListener {
    public static final String BUNDLE_ARG_CONVERSATION_LOCAL_ID = "issueId";
    private String conversationLaunchSource;
    EditText replyField;
    private String imageRefersId;
    ConversationVM conversationVM;
    private AttachmentMessageDM readableAttachmentMessage;
    private ConversationFragmentRenderer renderer;
    private int lastSoftInputMode;
    private int lastWindowFlags;
    private boolean retainMessageBoxOnUI;
    private static final String TAG = "Helpshift_ConvFragment";
    public static final String FRAGMENT_TAG = "HSConversationFragment";
    private ImagePickerFile selectedImageFile;
    private String selectedImageRefersId;
    private boolean shouldUpdateAttachment;

    public static ConversationFragment newInstance(Bundle bundle) {
        ConversationFragment conversationFragment = new ConversationFragment();
        conversationFragment.setArguments(bundle);
        return conversationFragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (this.isChangingConfigurations() && this.renderer != null) {
            this.retainMessageBoxOnUI = this.renderer.isReplyBoxVisible();
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.lastWindowFlags = this.getActivity().getWindow().getAttributes().flags;
        this.getActivity().getWindow().addFlags(2048);
        this.getActivity().getWindow().clearFlags(1024);
        View baseView = inflater.inflate(R.layout.hs__conversation_fragment, container, false);
        this.conversationLaunchSource = this.getArguments().getString("chatLaunchSource");
        return baseView;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.initialize(view);
        super.onViewCreated(view, savedInstanceState);
        HSLogger.d(TAG, "Now showing conversation screen");
    }

    private void initialize(View view) {
        Long conversationId = this.getArguments().getLong(BUNDLE_ARG_CONVERSATION_LOCAL_ID);
        final RecyclerView messagesRecyclerView = (RecyclerView)view.findViewById(R.id.hs__messagesList);
        this.replyField = (EditText)view.findViewById(R.id.hs__messageText);
        final ImageButton replyButton = (ImageButton)view.findViewById(R.id.hs__sendMessageBtn);
        View replyBoxView = view.findViewById(R.id.relativeLayout1);
        View confirmationBoxView = view.findViewById(R.id.hs__confirmation);
        this.renderer = new ConversationFragmentRenderer(this.getContext(), messagesRecyclerView, this.replyField, replyButton, this.getView(), replyBoxView, confirmationBoxView, this, this.getSupportFragment());
        this.conversationVM = HelpshiftContext.getCoreApi().getConversationViewModel(conversationId, this.renderer, this.retainMessageBoxOnUI);
        this.retainMessageBoxOnUI = false;
        this.conversationVM.setConversationLaunchSource(this.conversationLaunchSource);
        this.conversationVM.startLiveUpdates();
        if (this.shouldUpdateAttachment) {
            this.conversationVM.sendScreenShot(this.selectedImageFile, this.selectedImageRefersId);
            this.shouldUpdateAttachment = false;
        }
        this.replyField.addTextChangedListener((TextWatcher)new TextWatcherAdapter(){

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                ConversationFragment.this.conversationVM.setReply(charSequence.toString());
            }
        });
        this.replyField.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 4) {
                    replyButton.performClick();
                }
                return false;
            }
        });
        replyButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.conversationVM.sendTextMessage();
            }
        });
        view.findViewById(R.id.resolution_accepted_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.conversationVM.markConversationResolutionStatus(true);
            }
        });
        view.findViewById(R.id.resolution_rejected_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.replyField.requestFocus();
                KeyboardUtil.showKeyboard(ConversationFragment.this.getContext(), (View)ConversationFragment.this.replyField);
                ConversationFragment.this.conversationVM.markConversationResolutionStatus(false);
            }
        });
        messagesRecyclerView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (bottom < oldBottom) {
                    messagesRecyclerView.post(new Runnable(){

                        @Override
                        public void run() {
                            messagesRecyclerView.scrollToPosition(messagesRecyclerView.getAdapter().getItemCount() - 1);
                        }
                    });
                }
            }
        });
    }

    @Override
    public void onResume() {
        super.onResume();
        this.conversationVM.refreshVM();
        this.conversationVM.renderMenuItems();
        this.lastSoftInputMode = this.getActivity().getWindow().getAttributes().softInputMode;
        this.getActivity().getWindow().setSoftInputMode(16);
        this.conversationVM.setUserCanReadMessages(true);
        this.conversationVM.markMessagesAsSeen();
        this.conversationVM.clearNotifications();
        if (!this.isChangingConfigurations()) {
            this.conversationVM.pushAnalyticsEvent(AnalyticsEventType.OPEN_ISSUE, null);
            HelpshiftContext.getCoreApi().getConversationInboxPoller().startChatPoller();
        }
    }

    @Override
    public void onPause() {
        this.getActivity().getWindow().setSoftInputMode(this.lastSoftInputMode);
        KeyboardUtil.hideKeyboard(this.getContext(), (View)this.replyField);
        this.conversationVM.setUserCanReadMessages(false);
        this.conversationVM.markMessagesAsSeen();
        this.conversationVM.clearNotifications();
        this.conversationVM.resetIncrementMessageCountFlag();
        super.onPause();
    }

    @Override
    protected AppSessionConstants.Screen getViewName() {
        return AppSessionConstants.Screen.CONVERSATION;
    }

    @Override
    protected int getScreenshotMode() {
        return 3;
    }

    public boolean handleScreenshotAction(ScreenshotPreviewFragment.ScreenshotAction action, ImagePickerFile imagePickerFile, @Nullable String messageRefersId) {
        switch (action) {
            case SEND: {
                if (this.conversationVM == null) {
                    this.selectedImageFile = imagePickerFile;
                    this.selectedImageRefersId = messageRefersId;
                    this.shouldUpdateAttachment = true;
                } else {
                    this.conversationVM.sendScreenShot(imagePickerFile, messageRefersId);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getToolbarTitle() {
        return this.getString(R.string.hs__conversation_header);
    }

    @Override
    public void onAdminMessageLinkClicked(String url) {
        this.conversationVM.onAdminMessageLinkClicked(url);
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu2, View view) {
        if (view != null && view instanceof TextView) {
            MenuItem copyMenuItem = menu2.add(0, view.getId(), 0, R.string.hs__copy);
            final TextView copyTextView = (TextView)view;
            copyMenuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    ConversationFragment.this.copyToClipboard(copyTextView.getText().toString());
                    return true;
                }
            });
        }
    }

    @Override
    public void retryMessage(MessageDM messageDM) {
        this.conversationVM.retryMessage(messageDM);
    }

    @Override
    public void launchImagePicker(RequestScreenshotMessageDM message) {
        this.imageRefersId = message.serverId;
        this.conversationVM.onImageAttachmentButtonClick();
        Bundle bundle = new Bundle();
        bundle.putInt("key_screenshot_mode", this.getScreenshotMode());
        bundle.putString("key_refers_id", this.imageRefersId);
        this.getSupportFragment().launchImagePicker(true, bundle);
    }

    @Override
    public void handleReplyReviewButtonClick(RequestAppReviewMessageDM message) {
        this.conversationVM.handleAppReviewRequestClick(message);
    }

    @Override
    public void handleGenericAttachmentMessageClick(AdminAttachmentMessageDM message) {
        this.checkWriteStoragePermissionAndDelegateToVM(message.isWriteStoragePermissionRequired(), message);
    }

    @Override
    public void handleAdminImageAttachmentMessageClick(AdminImageAttachmentMessageDM message) {
        this.checkWriteStoragePermissionAndDelegateToVM(true, message);
    }

    @Override
    public void onStartNewConversationButtonClick() {
        this.conversationVM.onNewConversationButtonClicked();
        this.getSupportFragment().getSupportController().startConversationFlow();
    }

    @Override
    public void onCSATSurveySubmitted(int rating, String feedback) {
        this.conversationVM.onCSATSurveySubmitted(rating, feedback);
    }

    private void checkWriteStoragePermissionAndDelegateToVM(boolean isWriteStoragePermissionRequired, AttachmentMessageDM message) {
        this.readableAttachmentMessage = null;
        if (isWriteStoragePermissionRequired) {
            Device device = HelpshiftContext.getPlatform().getDevice();
            switch (device.checkPermission(Device.PermissionType.WRITE_STORAGE)) {
                case AVAILABLE: {
                    this.conversationVM.handleAdminAttachmentMessageClick(message);
                    break;
                }
                case UNAVAILABLE: {
                    this.startDownloadWithSystemService(message.attachmentUrl);
                    break;
                }
                case REQUESTABLE: {
                    this.readableAttachmentMessage = message;
                    this.requestWriteExternalStoragePermission(true);
                }
            }
        } else {
            this.conversationVM.handleAdminAttachmentMessageClick(message);
        }
    }

    @Override
    protected void onPermissionGranted(int requestCode) {
        switch (requestCode) {
            case 2: {
                Bundle bundle = new Bundle();
                bundle.putInt("key_screenshot_mode", this.getScreenshotMode());
                bundle.putString("key_refers_id", this.imageRefersId);
                this.getSupportFragment().launchImagePicker(false, bundle);
                break;
            }
            case 3: {
                if (this.readableAttachmentMessage == null) break;
                this.conversationVM.handleAdminAttachmentMessageClick(this.readableAttachmentMessage);
                this.readableAttachmentMessage = null;
            }
        }
    }

    private void startDownloadWithSystemService(String url) {
        DownloadManager downloadManager = (DownloadManager)this.getContext().getSystemService("download");
        Uri attachmentUri = Uri.parse((String)url);
        DownloadManager.Request request = new DownloadManager.Request(attachmentUri);
        request.setNotificationVisibility(1);
        downloadManager.enqueue(request);
        if (!this.isDetached()) {
            SnackbarUtil.showSnackbar(this.getView(), R.string.hs__starting_download, -1);
        }
    }

    @Override
    public void showConversationInfoScreen(String conversationServerId, String conversationPublishId) {
        this.getSupportFragment().getSupportController().showConversationInfoScreen(conversationServerId, conversationPublishId);
    }

    public void onDetach() {
        if (!this.isChangingConfigurations()) {
            HelpshiftContext.getCoreApi().getConversationInboxPoller().startSDKPoller();
        }
        super.onDetach();
    }

    @Override
    public void onDestroyView() {
        if (this.getActivity() != null) {
            this.getActivity().getWindow().clearFlags(2048);
            this.getActivity().getWindow().setFlags(this.lastWindowFlags, this.lastWindowFlags);
        }
        this.conversationVM.setConversationViewState(-1);
        this.conversationVM.unregisterRenderer();
        super.onDestroyView();
    }

    public void startLiveUpdates() {
        if (this.conversationVM != null) {
            this.conversationVM.startLiveUpdates();
        }
    }

    public void stopLiveUpdates() {
        if (this.conversationVM != null) {
            this.conversationVM.stopLiveUpdates();
        }
    }

    @Override
    public void onCreateOptionMenuCalled() {
        this.conversationVM.renderMenuItems();
    }

    @Override
    public void onMenuItemClicked(HSMenuItemType type) {
        switch (type) {
            case SCREENSHOT_ATTACHMENT: {
                this.imageRefersId = null;
                this.conversationVM.onImageAttachmentButtonClick();
                Bundle bundle = new Bundle();
                bundle.putInt("key_screenshot_mode", this.getScreenshotMode());
                bundle.putString("key_refers_id", null);
                this.getSupportFragment().launchImagePicker(true, bundle);
                break;
            }
            case CONVERSATION_INFO: {
                this.retainMessageBoxOnUI = this.renderer.isReplyBoxVisible();
                this.conversationVM.onConversationInfoButtonClick();
            }
        }
    }
}

