/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageButton;
import com.helpshift.R;
import com.helpshift.common.exception.ExceptionType;
import com.helpshift.common.exception.PlatformException;
import com.helpshift.conversation.activeconversation.ConversationRenderer;
import com.helpshift.conversation.activeconversation.message.ConversationFooterState;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.support.conversations.ConversationFragmentRouter;
import com.helpshift.support.conversations.MessagesAdapter;
import com.helpshift.support.fragments.HSMenuItemType;
import com.helpshift.support.fragments.IToolbarMenuItemRenderer;
import com.helpshift.support.util.KeyboardUtil;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.Styles;
import java.io.File;
import java.util.List;

class ConversationFragmentRenderer
implements ConversationRenderer {
    private Context context;
    RecyclerView messagesRecyclerView;
    MessagesAdapter messagesAdapter;
    private EditText replyField;
    private ImageButton replyButton;
    private View parentView;
    private ConversationFragmentRouter conversationFragmentRouter;
    private View replyBoxView;
    private View confirmationBoxView;
    private IToolbarMenuItemRenderer menuItemRenderer;

    ConversationFragmentRenderer(Context context, RecyclerView messagesRecyclerView, EditText replyField, ImageButton replyButton, View parentView, View replyBoxView, View confirmationBoxView, ConversationFragmentRouter conversationFragmentRouter, IToolbarMenuItemRenderer menuItemRenderer) {
        this.context = context;
        this.messagesRecyclerView = messagesRecyclerView;
        RecyclerView.ItemAnimator itemAnimator = this.messagesRecyclerView.getItemAnimator();
        if (itemAnimator instanceof SimpleItemAnimator) {
            ((SimpleItemAnimator)itemAnimator).setSupportsChangeAnimations(false);
        }
        this.parentView = parentView;
        this.replyField = replyField;
        this.replyButton = replyButton;
        this.replyBoxView = replyBoxView;
        this.confirmationBoxView = confirmationBoxView;
        this.conversationFragmentRouter = conversationFragmentRouter;
        this.menuItemRenderer = menuItemRenderer;
    }

    @Override
    public void initializeMessages(List<MessageDM> messages) {
        if (this.messagesAdapter == null) {
            this.messagesAdapter = new MessagesAdapter(this.context, messages, this.conversationFragmentRouter);
            this.messagesRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context));
            this.messagesRecyclerView.setAdapter((RecyclerView.Adapter)this.messagesAdapter);
            this.messagesRecyclerView.scrollToPosition(this.messagesAdapter.getItemCount() - 1);
        }
    }

    @Override
    public void addMessages(int startPosition, int itemCount) {
        this.messagesAdapter.notifyItemRangeInserted(startPosition, itemCount);
        int messageCount = this.messagesAdapter.getMessageCount();
        if (startPosition == messageCount - 1) {
            this.messagesRecyclerView.scrollToPosition(this.messagesAdapter.getItemCount() - 1);
        }
    }

    @Override
    public void updateMessages(int startPosition, int itemCount) {
        if (startPosition == 0 && itemCount == this.messagesAdapter.getMessageCount()) {
            this.messagesAdapter.notifyDataSetChanged();
        } else {
            this.messagesAdapter.notifyItemRangeChanged(startPosition, itemCount);
        }
    }

    @Override
    public void showConversationInformationButton() {
        this.changeMenuItemVisibility(HSMenuItemType.CONVERSATION_INFO, true);
    }

    @Override
    public void hideConversationInformationButton() {
        this.changeMenuItemVisibility(HSMenuItemType.CONVERSATION_INFO, false);
    }

    @Override
    public void showImageAttachmentButton() {
        this.changeMenuItemVisibility(HSMenuItemType.SCREENSHOT_ATTACHMENT, true);
    }

    @Override
    public void hideImageAttachmentButton() {
        this.changeMenuItemVisibility(HSMenuItemType.SCREENSHOT_ATTACHMENT, false);
    }

    @Override
    public void enableSendReplyButton() {
        this.replyButton.setEnabled(true);
        this.replyButton.setAlpha(255);
        com.helpshift.support.util.Styles.setSendMessageButtonIconColor(this.context, this.replyButton.getDrawable(), true);
    }

    @Override
    public void disableSendReplyButton() {
        this.replyButton.setEnabled(false);
        this.replyButton.setAlpha(64);
        com.helpshift.support.util.Styles.setSendMessageButtonIconColor(this.context, this.replyButton.getDrawable(), false);
    }

    @Override
    public void setReply(String reply) {
        this.replyField.setText((CharSequence)reply);
    }

    @Override
    public void showConversationResolutionQuestionUI() {
        KeyboardUtil.hideKeyboard(this.context, (View)this.replyField);
        this.confirmationBoxView.setVisibility(0);
    }

    @Override
    public void hideConversationResolutionQuestionUI() {
        this.confirmationBoxView.setVisibility(8);
    }

    @Override
    public void showSendReplyUI() {
        int bottomPadding = (int)Styles.dpToPx(this.context, 12.0f);
        this.messagesRecyclerView.setPadding(0, 0, 0, bottomPadding);
        this.replyBoxView.setVisibility(0);
    }

    @Override
    public void hideSendReplyUI() {
        this.messagesRecyclerView.setPadding(0, 0, 0, 0);
        this.replyBoxView.setVisibility(8);
    }

    @Override
    public void launchAttachment(String filePath, String contentType) {
        if (filePath != null) {
            File file = new File(filePath);
            if (file.exists()) {
                Uri uri;
                Intent intent = new Intent("android.intent.action.VIEW");
                if (Build.VERSION.SDK_INT >= 24) {
                    String packageName = this.context.getApplicationContext().getPackageName();
                    uri = FileProvider.getUriForFile((Context)this.context, (String)(packageName + ".helpshift.fileprovider"), (File)file);
                    intent.setFlags(1);
                } else {
                    uri = Uri.fromFile((File)file);
                }
                intent.setDataAndType(uri, contentType);
                if (intent.resolveActivity(this.context.getPackageManager()) != null) {
                    this.context.startActivity(intent);
                } else if (HelpshiftContext.getCoreApi().getDelegate().isDelegateRegistered()) {
                    HelpshiftContext.getCoreApi().getDelegate().displayAttachmentFile(file);
                } else {
                    this.showErrorView(PlatformException.NO_APPS_FOR_OPENING_ATTACHMENT);
                }
            } else {
                this.showErrorView(PlatformException.FILE_NOT_FOUND);
            }
        } else {
            this.showErrorView(PlatformException.FILE_NOT_FOUND);
        }
    }

    @Override
    public void showErrorView(ExceptionType exceptionType) {
        SnackbarUtil.showSnackbar(exceptionType, this.parentView);
    }

    @Override
    public void openAppReviewStore(String reviewUrl) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)reviewUrl));
        if (intent.resolveActivity(this.context.getPackageManager()) != null) {
            this.context.startActivity(intent);
        } else {
            this.showErrorView(PlatformException.NO_APPS_FOR_OPENING_ATTACHMENT);
        }
    }

    @Override
    public void showConversationInfoScreen(String serverId, String publishId) {
        if (this.conversationFragmentRouter != null) {
            this.conversationFragmentRouter.showConversationInfoScreen(serverId, publishId);
        }
    }

    @Override
    public void updateConversationFooterState(ConversationFooterState conversationFooterState) {
        if (this.messagesAdapter != null) {
            if (conversationFooterState != ConversationFooterState.NONE) {
                KeyboardUtil.hideKeyboard(this.context, (View)this.replyField);
            }
            this.messagesAdapter.setConversationFooterState(conversationFooterState);
            if (conversationFooterState != ConversationFooterState.NONE) {
                this.messagesRecyclerView.post(new Runnable(){

                    @Override
                    public void run() {
                        ConversationFragmentRenderer.this.messagesRecyclerView.scrollToPosition(ConversationFragmentRenderer.this.messagesAdapter.getItemCount() - 1);
                    }
                });
            }
        }
    }

    @Override
    public void showCSATSubmittedView() {
        SnackbarUtil.showSnackbar(this.parentView, this.context.getResources().getString(R.string.hs__csat_submit_toast), 0);
    }

    @Override
    public void updateAgentTypingIndicator(boolean shouldShowAgentTypingIndicator) {
        if (this.messagesAdapter != null) {
            this.messagesAdapter.setAgentTypingIndicatorVisibility(shouldShowAgentTypingIndicator);
            if (shouldShowAgentTypingIndicator) {
                int lastMessagePosition = this.messagesAdapter.getMessageCount() - 1;
                LinearLayoutManager layoutManager = (LinearLayoutManager)this.messagesRecyclerView.getLayoutManager();
                int lastVisibleItem = layoutManager.findLastVisibleItemPosition();
                if (lastVisibleItem == lastMessagePosition) {
                    int recyclerViewBottom = this.messagesRecyclerView.getBottom();
                    int lastItemBottom = layoutManager.findViewByPosition(lastVisibleItem).getBottom();
                    if (lastItemBottom < recyclerViewBottom) {
                        this.messagesRecyclerView.scrollToPosition(this.messagesAdapter.getItemCount() - 1);
                    }
                } else if (lastVisibleItem == -1) {
                    this.messagesRecyclerView.scrollToPosition(this.messagesAdapter.getItemCount() - 1);
                }
            }
        }
    }

    @Override
    public boolean isReplyBoxVisible() {
        return this.replyBoxView.getVisibility() == 0;
    }

    private void changeMenuItemVisibility(HSMenuItemType type, boolean isVisible) {
        if (this.menuItemRenderer != null) {
            this.menuItemRenderer.updateMenuItemVisibility(type, isVisible);
        }
    }
}

