/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ContextMenu;
import android.view.View;
import android.view.ViewGroup;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.ConversationFooterState;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestScreenshotMessageDM;
import com.helpshift.support.conversations.messages.ConversationFooterViewBinder;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.support.conversations.messages.MessageViewType;
import com.helpshift.support.conversations.messages.MessageViewTypeConverter;
import com.helpshift.support.conversations.messages.MessagesAdapterClickListener;
import java.util.List;

public class MessagesAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements MessageViewDataBinder.MessageItemClickListener,
ConversationFooterViewBinder.ConversationFooterClickListener {
    private MessageViewTypeConverter messageViewTypeConverter;
    private List<MessageDM> messages;
    private MessagesAdapterClickListener messagesAdapterClickListener;
    private ConversationFooterState conversationFooterState = ConversationFooterState.NONE;
    private boolean isAgentTypingIndicatorVisible = false;

    public MessagesAdapter(Context context, List<MessageDM> messages, MessagesAdapterClickListener messagesAdapterClickListener) {
        this.messageViewTypeConverter = new MessageViewTypeConverter(context);
        this.messages = messages;
        this.messagesAdapterClickListener = messagesAdapterClickListener;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == MessageViewType.CONVERSATION_FOOTER.key) {
            ConversationFooterViewBinder conversationFooterViewBinder = this.messageViewTypeConverter.getConversationFooterViewBinder();
            conversationFooterViewBinder.setConversationFooterClickListener(this);
            return conversationFooterViewBinder.createViewHolder(parent);
        }
        if (viewType == MessageViewType.AGENT_TYPING_FOOTER.key) {
            return this.messageViewTypeConverter.getAgentTypingMessageDataBinder().createViewHolder(parent);
        }
        MessageViewDataBinder messageViewDataBinder = this.messageViewTypeConverter.viewTypeToDataBinder(viewType);
        messageViewDataBinder.setMessageItemClickListener(this);
        return messageViewDataBinder.createViewHolder(parent);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        int viewType = holder.getItemViewType();
        if (viewType == MessageViewType.CONVERSATION_FOOTER.key) {
            this.messageViewTypeConverter.getConversationFooterViewBinder().bind((ConversationFooterViewBinder.ViewHolder)holder, this.conversationFooterState);
        } else if (viewType != MessageViewType.AGENT_TYPING_FOOTER.key) {
            MessageDM message = this.getItem(position);
            this.messageViewTypeConverter.viewTypeToDataBinder(viewType).bind(holder, message);
        }
    }

    public int getItemCount() {
        return this.getMessageCount() + this.getFooterCount();
    }

    private int getFooterCount() {
        int count = 0;
        if (this.isAgentTypingIndicatorVisible) {
            ++count;
        }
        if (this.conversationFooterState != ConversationFooterState.NONE) {
            ++count;
        }
        return count;
    }

    public int getItemViewType(int position) {
        if (position >= this.messages.size()) {
            return this.getFooterViewType(position - this.messages.size());
        }
        return this.messageViewTypeConverter.messageToViewType(this.getItem(position));
    }

    private MessageDM getItem(int position) {
        return this.messages.get(position);
    }

    @Override
    public void onAdminMessageLinkClicked(String url) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.onAdminMessageLinkClicked(url);
        }
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu2, View view) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.onCreateContextMenu(menu2, view);
        }
    }

    @Override
    public void retryMessage(int adapterPosition) {
        if (this.messagesAdapterClickListener != null && adapterPosition != this.messages.size()) {
            MessageDM readableMessage = this.getItem(adapterPosition);
            this.messagesAdapterClickListener.retryMessage(readableMessage);
        }
    }

    @Override
    public void launchImagePicker(RequestScreenshotMessageDM message) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.launchImagePicker(message);
        }
    }

    @Override
    public void handleReplyReviewButtonClick(RequestAppReviewMessageDM message) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.handleReplyReviewButtonClick(message);
        }
    }

    @Override
    public void handleGenericAttachmentMessageClick(AdminAttachmentMessageDM message) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.handleGenericAttachmentMessageClick(message);
        }
    }

    @Override
    public void handleAdminImageAttachmentMessageClick(AdminImageAttachmentMessageDM message) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.handleAdminImageAttachmentMessageClick(message);
        }
    }

    public void setAgentTypingIndicatorVisibility(boolean agentTypingIndicatorVisible) {
        if (this.isAgentTypingIndicatorVisible != agentTypingIndicatorVisible) {
            this.isAgentTypingIndicatorVisible = agentTypingIndicatorVisible;
            if (agentTypingIndicatorVisible) {
                this.notifyItemRangeInserted(this.messages.size(), 1);
            } else {
                this.notifyItemRangeRemoved(this.messages.size(), 1);
            }
        }
    }

    private int getFooterViewType(int position) {
        int returnType = -1;
        boolean isConversationFooterVisible = this.conversationFooterState != ConversationFooterState.NONE;
        switch (position) {
            case 0: {
                if (this.isAgentTypingIndicatorVisible) {
                    returnType = MessageViewType.AGENT_TYPING_FOOTER.key;
                    break;
                }
                if (!isConversationFooterVisible) break;
                returnType = MessageViewType.CONVERSATION_FOOTER.key;
                break;
            }
            case 1: {
                if (!isConversationFooterVisible) break;
                returnType = MessageViewType.CONVERSATION_FOOTER.key;
            }
        }
        return returnType;
    }

    public void setConversationFooterState(ConversationFooterState conversationFooter) {
        if (conversationFooter == null) {
            conversationFooter = ConversationFooterState.NONE;
        }
        this.conversationFooterState = conversationFooter;
        this.notifyDataSetChanged();
    }

    @Override
    public void onStartNewConversationButtonClick() {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.onStartNewConversationButtonClick();
        }
    }

    @Override
    public void onCSATSurveySubmitted(int rating, String feedback) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.onCSATSurveySubmitted(rating, feedback);
        }
    }

    public int getMessageCount() {
        return this.messages.size();
    }
}

