/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.support.util.Styles;

class AdminAttachmentMessageDataBinder
extends MessageViewDataBinder<ViewHolder, AdminAttachmentMessageDM> {
    AdminAttachmentMessageDataBinder(Context context) {
        super(context);
    }

    @Override
    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hs__msg_attachment_generic, parentView, false);
        return new ViewHolder(view);
    }

    @Override
    public void bind(ViewHolder viewHolder, final AdminAttachmentMessageDM message) {
        boolean isDownloadRingVisible = false;
        boolean isDownloadIconVisible = true;
        boolean isAttachmentIconVisible = false;
        boolean isProgressBarVisible = false;
        switch (message.state) {
            case DOWNLOAD_NOT_STARTED: {
                isDownloadRingVisible = true;
                break;
            }
            case DOWNLOADING: {
                isProgressBarVisible = true;
                break;
            }
            case DOWNLOADED: {
                isDownloadIconVisible = false;
                isAttachmentIconVisible = true;
            }
        }
        this.setViewVisibility(viewHolder.downloadButtonRing, isDownloadRingVisible);
        this.setViewVisibility((View)viewHolder.downloadIcon, isDownloadIconVisible);
        this.setViewVisibility((View)viewHolder.attachmentIcon, isAttachmentIconVisible);
        this.setViewVisibility((View)viewHolder.progress, isProgressBarVisible);
        viewHolder.subText.setText((CharSequence)message.getSubText());
        viewHolder.fileName.setText((CharSequence)message.fileName);
        viewHolder.fileSize.setText((CharSequence)message.getFormattedFileSize());
        viewHolder.messageContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AdminAttachmentMessageDataBinder.this.messageClickListener != null) {
                    AdminAttachmentMessageDataBinder.this.messageClickListener.handleGenericAttachmentMessageClick(message);
                }
            }
        });
    }

    protected final class ViewHolder
    extends RecyclerView.ViewHolder {
        final TextView fileName;
        final TextView fileSize;
        final View messageContainer;
        final View downloadButtonRing;
        final ProgressBar progress;
        final ImageView downloadIcon;
        final ImageView attachmentIcon;
        final TextView subText;

        ViewHolder(View itemView) {
            super(itemView);
            this.fileName = (TextView)itemView.findViewById(R.id.attachment_file_name);
            this.fileSize = (TextView)itemView.findViewById(R.id.attachment_file_size);
            this.messageContainer = itemView.findViewById(R.id.admin_message);
            this.downloadButtonRing = itemView.findViewById(R.id.download_button_ring);
            this.downloadIcon = (ImageView)itemView.findViewById(R.id.download_icon);
            this.progress = (ProgressBar)itemView.findViewById(R.id.progress);
            this.attachmentIcon = (ImageView)itemView.findViewById(R.id.attachment_icon);
            this.subText = (TextView)itemView.findViewById(R.id.attachment_date);
            Styles.setAdminChatBubbleColor(AdminAttachmentMessageDataBinder.this.context, itemView.findViewById(R.id.admin_message).getBackground());
            Styles.setAccentColor(AdminAttachmentMessageDataBinder.this.context, this.downloadIcon.getDrawable());
            Styles.setAccentColor(AdminAttachmentMessageDataBinder.this.context, this.attachmentIcon.getDrawable());
            Styles.setAccentColor(AdminAttachmentMessageDataBinder.this.context, this.progress.getIndeterminateDrawable());
            Styles.setAccentColor(AdminAttachmentMessageDataBinder.this.context, this.downloadButtonRing.getBackground());
        }
    }
}

