/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.support.util.Styles;
import com.helpshift.support.views.HSRoundedImageView;

class AdminImageAttachmentMessageDataBinder
extends MessageViewDataBinder<ViewHolder, AdminImageAttachmentMessageDM> {
    AdminImageAttachmentMessageDataBinder(Context context) {
        super(context);
    }

    @Override
    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hs__msg_attachment_image, parentView, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void bind(ViewHolder viewHolder, final AdminImageAttachmentMessageDM message) {
        boolean progressBarContainerVisibility = true;
        boolean progressBarVisibility = true;
        boolean downloadButtonVisibility = false;
        boolean imageVisibility = true;
        boolean isImageClickable = true;
        String imagePath = null;
        switch (message.state) {
            case DOWNLOAD_NOT_STARTED: {
                downloadButtonVisibility = false;
                progressBarVisibility = true;
                break;
            }
            case THUMBNAIL_DOWNLOADING: {
                imageVisibility = false;
                isImageClickable = false;
                break;
            }
            case THUMBNAIL_DOWNLOADED: {
                imagePath = message.checkAndGetThumbnailFilePath();
                downloadButtonVisibility = true;
                progressBarVisibility = false;
                break;
            }
            case IMAGE_DOWNLOADING: {
                imagePath = message.checkAndGetThumbnailFilePath();
                isImageClickable = false;
                break;
            }
            case IMAGE_DOWNLOADED: {
                imagePath = message.checkAndGetFilePath();
                progressBarVisibility = false;
                progressBarContainerVisibility = false;
            }
        }
        if (imagePath == null) {
            imageVisibility = false;
        }
        this.setViewVisibility(viewHolder.downloadProgressbarContainer, progressBarContainerVisibility);
        this.setViewVisibility((View)viewHolder.progress, progressBarVisibility);
        this.setViewVisibility(viewHolder.downloadButtonView, downloadButtonVisibility);
        this.setViewVisibility((View)viewHolder.image, imageVisibility);
        viewHolder.image.loadImage(imagePath);
        viewHolder.subText.setText((CharSequence)message.getSubText());
        viewHolder.fileSize.setText((CharSequence)message.getFormattedFileSize());
        View.OnClickListener clickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (AdminImageAttachmentMessageDataBinder.this.messageClickListener != null) {
                    AdminImageAttachmentMessageDataBinder.this.messageClickListener.handleAdminImageAttachmentMessageClick(message);
                }
            }
        };
        if (downloadButtonVisibility) {
            viewHolder.downloadButtonView.setOnClickListener(clickListener);
        } else {
            viewHolder.downloadButtonView.setOnClickListener(null);
        }
        if (imageVisibility && isImageClickable) {
            viewHolder.image.setOnClickListener(clickListener);
        } else {
            viewHolder.image.setOnClickListener(null);
        }
    }

    protected final class ViewHolder
    extends RecyclerView.ViewHolder {
        final HSRoundedImageView image;
        final ProgressBar progress;
        final View downloadButtonView;
        final View downloadProgressbarContainer;
        private final View downloadButton;
        final TextView fileSize;
        final TextView subText;

        ViewHolder(View itemView) {
            super(itemView);
            this.image = (HSRoundedImageView)itemView.findViewById(R.id.admin_attachment_imageview);
            this.downloadButtonView = itemView.findViewById(R.id.download_button);
            this.downloadProgressbarContainer = itemView.findViewById(R.id.download_progressbar_container);
            this.progress = (ProgressBar)itemView.findViewById(R.id.download_attachment_progressbar);
            this.downloadButton = itemView.findViewById(R.id.admin_message);
            this.fileSize = (TextView)itemView.findViewById(R.id.attachment_file_size);
            this.subText = (TextView)itemView.findViewById(R.id.date);
            Styles.setAdminChatBubbleColor(AdminImageAttachmentMessageDataBinder.this.context, this.downloadButton.getBackground());
            Styles.setImageAttachmentProgressBackgroundColor(AdminImageAttachmentMessageDataBinder.this.context, this.downloadProgressbarContainer.getBackground());
            Styles.setAttachmentProgressBarColor(AdminImageAttachmentMessageDataBinder.this.context, this.progress);
        }
    }
}

