/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.support.util.Styles;
import com.helpshift.util.HSLinkify;

class AdminMessageViewDataBinder
extends MessageViewDataBinder<ViewHolder, MessageDM>
implements HSLinkify.LinkClickListener {
    AdminMessageViewDataBinder(Context context) {
        super(context);
    }

    @Override
    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)parentView.getContext()).inflate(R.layout.hs__msg_txt_admin, parentView, false);
        Styles.setAdminChatBubbleColor(this.context, view.findViewById(R.id.admin_message_container).getBackground());
        ViewHolder viewHolder = new ViewHolder(view);
        viewHolder.setListeners();
        return viewHolder;
    }

    @Override
    public void bind(ViewHolder viewHolder, MessageDM message) {
        viewHolder.messageText.setText((CharSequence)this.escapeHtml(message.body));
        viewHolder.dateText.setText((CharSequence)message.getSubText());
        this.linkify(viewHolder.messageText, this);
    }

    @Override
    public void onLinkClicked(String url) {
        if (this.messageClickListener != null) {
            this.messageClickListener.onAdminMessageLinkClicked(url);
        }
    }

    protected final class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnCreateContextMenuListener {
        final TextView messageText;
        final TextView dateText;

        ViewHolder(View itemView) {
            super(itemView);
            this.messageText = (TextView)itemView.findViewById(R.id.admin_message_text);
            this.dateText = (TextView)itemView.findViewById(R.id.admin_date_text);
        }

        void setListeners() {
            this.messageText.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
        }

        public void onCreateContextMenu(ContextMenu menu2, View view, ContextMenu.ContextMenuInfo menuInfo) {
            if (AdminMessageViewDataBinder.this.messageClickListener != null) {
                AdminMessageViewDataBinder.this.messageClickListener.onCreateContextMenu(menu2, view);
            }
        }
    }
}

