/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.conversation.activeconversation.message.ConversationFooterState;
import com.helpshift.support.widget.CSATView;

public class ConversationFooterViewBinder {
    private Context context;
    ConversationFooterClickListener footerClickListener;

    public ConversationFooterViewBinder(Context context) {
        this.context = context;
    }

    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)parentView.getContext()).inflate(R.layout.hs__messages_list_footer, parentView, false);
        return new ViewHolder(view);
    }

    public void bind(ViewHolder viewHolder, ConversationFooterState conversationFooterState) {
        boolean showStartNewConversationView = false;
        boolean showFooterMessage = true;
        boolean showCSATView = false;
        boolean showConversationArchivalView = false;
        boolean showConversationFooter = true;
        String footerMessage = this.context.getResources().getString(R.string.hs__conversation_end_msg);
        switch (conversationFooterState) {
            case NONE: {
                showFooterMessage = false;
                showConversationFooter = false;
                break;
            }
            case CONVERSATION_ENDED_MESSAGE: {
                footerMessage = this.context.getResources().getString(R.string.hs__confirmation_footer_msg);
                break;
            }
            case START_NEW_CONVERSATION: {
                showStartNewConversationView = true;
                break;
            }
            case CSAT_RATING: {
                showStartNewConversationView = true;
                footerMessage = this.context.getResources().getString(R.string.hs__confirmation_footer_msg);
                showCSATView = true;
                break;
            }
            case ARCHIVAL_MESSAGE: {
                showFooterMessage = false;
                showConversationArchivalView = true;
                showStartNewConversationView = true;
            }
        }
        if (showConversationFooter) {
            viewHolder.conversationFooter.setVisibility(0);
            if (showFooterMessage) {
                viewHolder.footerMessage.setText((CharSequence)footerMessage);
                viewHolder.footerMessage.setVisibility(0);
            } else {
                viewHolder.footerMessage.setVisibility(8);
            }
            if (showStartNewConversationView) {
                viewHolder.newConversationBox.setVisibility(0);
                viewHolder.newConversationButton.setOnClickListener((View.OnClickListener)viewHolder);
            } else {
                viewHolder.newConversationBox.setVisibility(8);
                viewHolder.newConversationBox.setOnClickListener(null);
            }
            if (showCSATView) {
                viewHolder.csatView.setVisibility(0);
                viewHolder.csatView.setCSATListener(viewHolder);
            } else {
                viewHolder.csatView.setVisibility(8);
                viewHolder.csatView.setCSATListener(null);
            }
            if (showConversationArchivalView) {
                viewHolder.issueArchivalMessageViewLayout.setVisibility(0);
            } else {
                viewHolder.issueArchivalMessageViewLayout.setVisibility(8);
            }
        } else {
            viewHolder.conversationFooter.setVisibility(8);
        }
    }

    public void setConversationFooterClickListener(ConversationFooterClickListener footerClickListener) {
        this.footerClickListener = footerClickListener;
    }

    public static interface ConversationFooterClickListener {
        public void onStartNewConversationButtonClick();

        public void onCSATSurveySubmitted(int var1, String var2);
    }

    public final class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener,
    CSATView.CSATListener {
        final View conversationFooter;
        final TextView footerMessage;
        final LinearLayout newConversationBox;
        final Button newConversationButton;
        final CSATView csatView;
        final View issueArchivalMessageViewLayout;

        public ViewHolder(View itemView) {
            super(itemView);
            this.conversationFooter = itemView;
            this.footerMessage = (TextView)itemView.findViewById(R.id.footer_message);
            this.newConversationBox = (LinearLayout)itemView.findViewById(R.id.hs__new_conversation);
            this.newConversationButton = (Button)itemView.findViewById(R.id.hs__new_conversation_btn);
            this.csatView = (CSATView)itemView.findViewById(R.id.csat_view_layout);
            this.issueArchivalMessageViewLayout = itemView.findViewById(R.id.issue_archival_message_view_stub);
        }

        public void onClick(View v) {
            if (ConversationFooterViewBinder.this.footerClickListener != null) {
                ConversationFooterViewBinder.this.footerClickListener.onStartNewConversationButtonClick();
            }
        }

        @Override
        public void sendCSATSurvey(int rating, String feedback) {
            if (ConversationFooterViewBinder.this.footerClickListener != null) {
                ConversationFooterViewBinder.this.footerClickListener.onCSATSurveySubmitted(rating, feedback);
            }
        }
    }
}

