/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.ContextMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestScreenshotMessageDM;
import com.helpshift.util.HSLinkify;
import com.helpshift.util.HSPattern;

public abstract class MessageViewDataBinder<VH extends RecyclerView.ViewHolder, M extends MessageDM> {
    protected Context context;
    protected MessageItemClickListener messageClickListener;
    protected static final float BUBBLE_OPAGUE = 1.0f;
    protected static final float BUBBLE_TRANSLUCENT = 0.56f;

    public MessageViewDataBinder(Context context) {
        this.context = context;
    }

    public void setMessageItemClickListener(MessageItemClickListener messageClickListener) {
        this.messageClickListener = messageClickListener;
    }

    protected void linkify(TextView textView, HSLinkify.LinkClickListener linkClickListener) {
        HSLinkify.addLinks(textView, 15, linkClickListener);
        HSLinkify.addLinks(textView, HSPattern.getUrlPattern(), null, null, null, linkClickListener);
    }

    public abstract VH createViewHolder(ViewGroup var1);

    public abstract void bind(VH var1, M var2);

    protected String escapeHtml(String input) {
        return Html.fromHtml((String)input.replace("\n", "<br/>")).toString();
    }

    protected void setViewVisibility(View view, boolean value) {
        if (value) {
            view.setVisibility(0);
        } else {
            view.setVisibility(8);
        }
    }

    public static interface MessageItemClickListener {
        public void onAdminMessageLinkClicked(String var1);

        public void onCreateContextMenu(ContextMenu var1, View var2);

        public void retryMessage(int var1);

        public void launchImagePicker(RequestScreenshotMessageDM var1);

        public void handleReplyReviewButtonClick(RequestAppReviewMessageDM var1);

        public void handleGenericAttachmentMessageClick(AdminAttachmentMessageDM var1);

        public void handleAdminImageAttachmentMessageClick(AdminImageAttachmentMessageDM var1);
    }
}

