/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.util.SparseArray;
import com.helpshift.conversation.activeconversation.message.AcceptedAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminMessageDM;
import com.helpshift.conversation.activeconversation.message.ConfirmationRejectedMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestForReopenMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.UserMessageDM;
import com.helpshift.support.conversations.messages.AcceptedAppReviewMessageDataBinder;
import com.helpshift.support.conversations.messages.AdminAttachmentMessageDataBinder;
import com.helpshift.support.conversations.messages.AdminImageAttachmentMessageDataBinder;
import com.helpshift.support.conversations.messages.AdminMessageViewDataBinder;
import com.helpshift.support.conversations.messages.AgentTypingMessageDataBinder;
import com.helpshift.support.conversations.messages.ConfirmationRejectedMessageDataBinder;
import com.helpshift.support.conversations.messages.ConversationFooterViewBinder;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.support.conversations.messages.MessageViewType;
import com.helpshift.support.conversations.messages.RequestAppReviewMessageDataBinder;
import com.helpshift.support.conversations.messages.RequestScreenshotMessageDataBinder;
import com.helpshift.support.conversations.messages.ScreenshotMessageViewDataBinder;
import com.helpshift.support.conversations.messages.UserMessageViewDataBinder;

public class MessageViewTypeConverter {
    private SparseArray<MessageViewDataBinder> viewTypeToDataBinderMap = new SparseArray();
    private ConversationFooterViewBinder conversationFooterViewBinder;
    private AgentTypingMessageDataBinder agentTypingMessageDataBinder;

    public MessageViewTypeConverter(Context context) {
        this.viewTypeToDataBinderMap.put(MessageViewType.ADMIN_TEXT_MESSAGE.key, (Object)new AdminMessageViewDataBinder(context));
        this.viewTypeToDataBinderMap.put(MessageViewType.USER_TEXT_MESSAGE.key, (Object)new UserMessageViewDataBinder(context));
        this.viewTypeToDataBinderMap.put(MessageViewType.USER_SCREENSHOT_ATTACHMENT.key, (Object)new ScreenshotMessageViewDataBinder(context));
        this.viewTypeToDataBinderMap.put(MessageViewType.ADMIN_ATTACHMENT_IMAGE.key, (Object)new AdminImageAttachmentMessageDataBinder(context));
        this.viewTypeToDataBinderMap.put(MessageViewType.ADMIN_ATTACHMENT_GENERIC.key, (Object)new AdminAttachmentMessageDataBinder(context));
        this.viewTypeToDataBinderMap.put(MessageViewType.REQUESTED_APP_REVIEW.key, (Object)new RequestAppReviewMessageDataBinder(context));
        this.viewTypeToDataBinderMap.put(MessageViewType.ACCEPTED_APP_REVIEW.key, (Object)new AcceptedAppReviewMessageDataBinder(context));
        this.viewTypeToDataBinderMap.put(MessageViewType.CONFIRMATION_REJECTED.key, (Object)new ConfirmationRejectedMessageDataBinder(context));
        this.viewTypeToDataBinderMap.put(MessageViewType.ADMIN_REQUEST_ATTACHMENT.key, (Object)new RequestScreenshotMessageDataBinder(context));
        this.viewTypeToDataBinderMap.put(MessageViewType.REQUEST_FOR_REOPEN.key, (Object)new AdminMessageViewDataBinder(context));
        this.conversationFooterViewBinder = new ConversationFooterViewBinder(context);
        this.agentTypingMessageDataBinder = new AgentTypingMessageDataBinder(context);
    }

    public int messageToViewType(MessageDM message) {
        if (message instanceof AdminMessageDM) {
            return MessageViewType.ADMIN_TEXT_MESSAGE.key;
        }
        if (message instanceof UserMessageDM) {
            return MessageViewType.USER_TEXT_MESSAGE.key;
        }
        if (message instanceof ScreenshotMessageDM) {
            return MessageViewType.USER_SCREENSHOT_ATTACHMENT.key;
        }
        if (message instanceof AdminImageAttachmentMessageDM) {
            return MessageViewType.ADMIN_ATTACHMENT_IMAGE.key;
        }
        if (message instanceof AdminAttachmentMessageDM) {
            return MessageViewType.ADMIN_ATTACHMENT_GENERIC.key;
        }
        if (message instanceof RequestAppReviewMessageDM) {
            return MessageViewType.REQUESTED_APP_REVIEW.key;
        }
        if (message instanceof AcceptedAppReviewMessageDM) {
            return MessageViewType.ACCEPTED_APP_REVIEW.key;
        }
        if (message instanceof ConfirmationRejectedMessageDM) {
            return MessageViewType.CONFIRMATION_REJECTED.key;
        }
        if (message instanceof RequestScreenshotMessageDM) {
            return MessageViewType.ADMIN_REQUEST_ATTACHMENT.key;
        }
        if (message instanceof RequestForReopenMessageDM) {
            return MessageViewType.REQUEST_FOR_REOPEN.key;
        }
        return -1;
    }

    public MessageViewDataBinder viewTypeToDataBinder(int viewType) {
        return (MessageViewDataBinder)this.viewTypeToDataBinderMap.get(viewType);
    }

    public ConversationFooterViewBinder getConversationFooterViewBinder() {
        return this.conversationFooterViewBinder;
    }

    public AgentTypingMessageDataBinder getAgentTypingMessageDataBinder() {
        return this.agentTypingMessageDataBinder;
    }
}

