/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.support.util.Styles;
import com.helpshift.support.views.HSRoundedImageView;
import com.helpshift.util.TextUtils;

public class ScreenshotMessageViewDataBinder
extends MessageViewDataBinder<ViewHolder, ScreenshotMessageDM> {
    public ScreenshotMessageViewDataBinder(Context context) {
        super(context);
    }

    @Override
    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hs__msg_screenshot_status, parentView, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void bind(ViewHolder viewHolder, ScreenshotMessageDM message) {
        String imagePath = message.getFilePath();
        boolean isProgressBarVisible = false;
        ViewHolder clickListener = null;
        String subtext = null;
        int subtextColor = Styles.getColor(this.context, 16842808);
        float containerAlpha = 0.56f;
        boolean isImageViewVisible = !TextUtils.isEmpty(imagePath);
        switch (message.state) {
            case UNSENT_RETRYABLE: {
                clickListener = viewHolder;
                subtext = this.context.getResources().getString(R.string.hs__sending_fail_msg);
                subtextColor = Styles.getColor(this.context, R.attr.hs__errorTextColor);
                break;
            }
            case UNSENT_NOT_RETRYABLE: {
                subtext = this.context.getResources().getString(R.string.hs__message_not_sent);
                subtextColor = Styles.getColor(this.context, R.attr.hs__errorTextColor);
                break;
            }
            case SENDING: {
                isProgressBarVisible = true;
                subtext = this.context.getResources().getString(R.string.hs__sending_msg);
                break;
            }
            case SENT: {
                subtext = message.getSubText();
                containerAlpha = 1.0f;
                if (!TextUtils.isEmpty(imagePath)) break;
                isProgressBarVisible = true;
                containerAlpha = 0.56f;
            }
        }
        viewHolder.image.loadImage(imagePath);
        this.setViewVisibility((View)viewHolder.image, isImageViewVisible);
        viewHolder.subText.setVisibility(0);
        viewHolder.subText.setText((CharSequence)subtext);
        viewHolder.subText.setTextColor(subtextColor);
        viewHolder.imageViewContainer.setAlpha(containerAlpha);
        this.setViewVisibility(viewHolder.progressBarContainer, isProgressBarVisible);
        viewHolder.clickableView.setOnClickListener((View.OnClickListener)clickListener);
    }

    protected final class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private final ProgressBar progress;
        final View progressBarContainer;
        final HSRoundedImageView image;
        final TextView subText;
        final View imageViewContainer;
        final View clickableView;

        ViewHolder(View itemView) {
            super(itemView);
            this.imageViewContainer = itemView.findViewById(R.id.imageview_container);
            this.progress = (ProgressBar)itemView.findViewById(R.id.upload_attachment_progressbar);
            this.progressBarContainer = itemView.findViewById(R.id.progressbar_container);
            this.image = (HSRoundedImageView)itemView.findViewById(R.id.user_attachment_imageview);
            this.subText = (TextView)itemView.findViewById(R.id.date);
            this.clickableView = itemView.findViewById(R.id.user_message);
            Styles.setUserChatBubbleColor(ScreenshotMessageViewDataBinder.this.context, this.imageViewContainer.getBackground());
            Styles.setImageAttachmentProgressBackgroundColor(ScreenshotMessageViewDataBinder.this.context, this.progressBarContainer.getBackground());
            Styles.setAttachmentProgressBarColor(ScreenshotMessageViewDataBinder.this.context, this.progress);
        }

        public void onClick(View v) {
            if (ScreenshotMessageViewDataBinder.this.messageClickListener != null) {
                ScreenshotMessageViewDataBinder.this.messageClickListener.retryMessage(this.getAdapterPosition());
            }
        }
    }
}

