/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.util.Linkify;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.conversation.activeconversation.message.UserMessageDM;
import com.helpshift.conversation.activeconversation.message.UserMessageState;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.util.Styles;

public class UserMessageViewDataBinder
extends MessageViewDataBinder<ViewHolder, UserMessageDM> {
    public UserMessageViewDataBinder(Context context) {
        super(context);
    }

    @Override
    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)parentView.getContext()).inflate(R.layout.hs__msg_txt_user, parentView, false);
        com.helpshift.support.util.Styles.setUserChatBubbleColor(this.context, view.findViewById(R.id.user_message_container).getBackground());
        ViewHolder viewHolder = new ViewHolder(view);
        viewHolder.setListeners();
        return viewHolder;
    }

    @Override
    public void bind(ViewHolder viewHolder, UserMessageDM message) {
        UserMessageState state = message.state;
        viewHolder.messageText.setText((CharSequence)this.escapeHtml(message.body));
        switch (state) {
            case UNSENT_NOT_RETRYABLE: {
                viewHolder.subText.setText(R.string.hs__message_not_sent);
                viewHolder.subText.setTextColor(Styles.getColor(this.context, R.attr.hs__errorTextColor));
                viewHolder.messageBubble.setAlpha(0.56f);
                Linkify.addLinks((TextView)viewHolder.messageText, (int)15);
                viewHolder.messageText.setOnClickListener(null);
                viewHolder.messageText.setEnabled(true);
                break;
            }
            case UNSENT_RETRYABLE: {
                viewHolder.subText.setText(R.string.hs__sending_fail_msg);
                viewHolder.subText.setTextColor(Styles.getColor(this.context, R.attr.hs__errorTextColor));
                viewHolder.messageBubble.setAlpha(0.56f);
                viewHolder.messageText.setOnClickListener((View.OnClickListener)viewHolder);
                viewHolder.messageText.setEnabled(true);
                break;
            }
            case SENDING: {
                viewHolder.subText.setText(R.string.hs__sending_msg);
                viewHolder.subText.setTextColor(Styles.getColor(this.context, 16842808));
                viewHolder.messageBubble.setAlpha(0.56f);
                viewHolder.messageText.setOnClickListener(null);
                viewHolder.messageText.setEnabled(false);
                break;
            }
            case SENT: {
                viewHolder.subText.setText((CharSequence)message.getSubText());
                viewHolder.subText.setTextColor(Styles.getColor(this.context, 16842808));
                viewHolder.messageBubble.setAlpha(1.0f);
                Linkify.addLinks((TextView)viewHolder.messageText, (int)15);
                viewHolder.messageText.setOnClickListener(null);
                viewHolder.messageText.setEnabled(true);
            }
        }
    }

    protected final class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnCreateContextMenuListener,
    View.OnClickListener {
        final TextView messageText;
        final TextView subText;
        final View messageBubble;

        ViewHolder(View itemView) {
            super(itemView);
            this.messageText = (TextView)itemView.findViewById(R.id.user_message_text);
            this.subText = (TextView)itemView.findViewById(R.id.user_date_text);
            this.messageBubble = itemView.findViewById(R.id.user_message_container);
        }

        void setListeners() {
            this.messageText.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
        }

        public void onCreateContextMenu(ContextMenu menu2, View view, ContextMenu.ContextMenuInfo menuInfo) {
            if (UserMessageViewDataBinder.this.messageClickListener != null) {
                UserMessageViewDataBinder.this.messageClickListener.onCreateContextMenu(menu2, view);
            }
        }

        public void onClick(View view) {
            if (UserMessageViewDataBinder.this.messageClickListener != null) {
                UserMessageViewDataBinder.this.messageClickListener.retryMessage(this.getAdapterPosition());
            }
        }
    }
}

