/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.flows;

import android.os.Bundle;
import android.support.annotation.NonNull;
import com.helpshift.support.ApiConfig;
import com.helpshift.support.SupportInternal;
import com.helpshift.support.controllers.SupportController;
import com.helpshift.support.flows.Flow;
import com.helpshift.support.util.ConfigUtil;
import java.util.HashMap;
import java.util.Map;

public class ConversationFlow
implements Flow {
    private final int labelResId;
    private final String label;
    private final HashMap config;
    private SupportController supportController;

    public ConversationFlow(int labelResId) {
        this(labelResId, new HashMap());
    }

    public ConversationFlow(int labelResId, Map config) {
        this.labelResId = labelResId;
        this.config = new HashMap(config);
        this.label = null;
    }

    public ConversationFlow(int labelResId, @NonNull ApiConfig config) {
        this(labelResId, ConfigUtil.validateAndConvertToMap(config));
    }

    public ConversationFlow(String label) {
        this(label, new HashMap());
    }

    public ConversationFlow(String label, Map config) {
        this.label = label;
        this.config = new HashMap(config);
        this.labelResId = 0;
    }

    public ConversationFlow(String label, @NonNull ApiConfig config) {
        this(label, ConfigUtil.validateAndConvertToMap(config));
    }

    public void setSupportController(SupportController supportController) {
        this.supportController = supportController;
    }

    @Override
    public int getLabelResId() {
        return this.labelResId;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void performAction() {
        Bundle cleanConfig = SupportInternal.cleanConfig(SupportInternal.removeShowConversationUnsupportedConfigs(this.config));
        cleanConfig.putString("chatLaunchSource", "support");
        this.supportController.startConversationFlow(cleanConfig, true);
    }
}

