/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.flows;

import com.helpshift.support.controllers.SupportController;
import com.helpshift.support.flows.Flow;
import java.util.List;

public class DynamicFormFlow
implements Flow {
    private final int labelResId;
    private final String label;
    private final List<Flow> flowList;
    private SupportController supportController;

    public DynamicFormFlow(int labelResId, List<Flow> flowList) {
        this.labelResId = labelResId;
        this.flowList = flowList;
        this.label = null;
    }

    public DynamicFormFlow(String label, List<Flow> flowList) {
        this.label = label;
        this.flowList = flowList;
        this.labelResId = 0;
    }

    public void setSupportController(SupportController supportController) {
        this.supportController = supportController;
    }

    @Override
    public int getLabelResId() {
        return this.labelResId;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void performAction() {
        if (this.labelResId != 0) {
            this.supportController.startDynamicForm(this.labelResId, this.flowList, true);
        } else {
            this.supportController.startDynamicForm(this.label, this.flowList, true);
        }
    }
}

