/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.flows;

import android.os.Bundle;
import android.support.annotation.NonNull;
import com.helpshift.support.ApiConfig;
import com.helpshift.support.SupportInternal;
import com.helpshift.support.controllers.SupportController;
import com.helpshift.support.flows.Flow;
import com.helpshift.support.util.ConfigUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FAQSectionFlow
implements Flow {
    private final int labelResId;
    private final String label;
    private final String sectionPublishId;
    private final HashMap config;
    private SupportController supportController;

    public FAQSectionFlow(int labelResId, String sectionPublishId) {
        this(labelResId, sectionPublishId, new HashMap());
    }

    public FAQSectionFlow(int labelResId, String sectionPublishId, Map config) {
        this.labelResId = labelResId;
        this.sectionPublishId = sectionPublishId;
        this.config = new HashMap(config);
        this.label = null;
    }

    public FAQSectionFlow(int labelResId, @NonNull String sectionPublishId, @NonNull ApiConfig config) {
        this(labelResId, sectionPublishId, ConfigUtil.validateAndConvertToMap(config));
    }

    public FAQSectionFlow(String label, String sectionPublishId) {
        this(label, sectionPublishId, new HashMap());
    }

    public FAQSectionFlow(String label, String sectionPublishId, Map config) {
        this.label = label;
        this.sectionPublishId = sectionPublishId;
        this.config = new HashMap(config);
        this.labelResId = 0;
    }

    public FAQSectionFlow(String label, @NonNull String sectionPublishId, @NonNull ApiConfig config) {
        this(label, sectionPublishId, ConfigUtil.validateAndConvertToMap(config));
    }

    public void setSupportController(SupportController supportController) {
        this.supportController = supportController;
    }

    @Override
    public int getLabelResId() {
        return this.labelResId;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void performAction() {
        Bundle bundle = SupportInternal.cleanConfig(SupportInternal.removeFAQFlowUnsupportedConfigs(this.config));
        bundle.putString("sectionPublishId", this.sectionPublishId);
        bundle.putInt("support_mode", 2);
        List customContactUsFlows = (List)this.config.get("customContactUsFlows");
        this.supportController.startFaqFlow(bundle, true, customContactUsFlows);
    }
}

