/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.storage.IMAppSessionStorage;
import com.helpshift.support.util.AppSessionConstants;
import com.helpshift.support.util.Styles;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.TextUtils;
import com.helpshift.views.HSTooltip;

public class ConversationInfoFragment
extends MainFragment {
    public static final String BUNDLE_ARG_ISSUE_PUBLISH_ID = "issue_publish_id";
    private static final AppSessionConstants.Screen screenType = AppSessionConstants.Screen.CONVERSATION_INFO;
    public static final String FRAGMENT_TAG = "HSConversationInfoFragment";

    public static ConversationInfoFragment newInstance(Bundle bundle) {
        ConversationInfoFragment conversationInfoFragment = new ConversationInfoFragment();
        conversationInfoFragment.setArguments(bundle);
        return conversationInfoFragment;
    }

    @Override
    public void onStart() {
        super.onStart();
        IMAppSessionStorage.getInstance().set("current_open_screen", screenType);
    }

    public void onResume() {
        super.onResume();
        this.setToolbarTitle(this.getString(R.string.hs__conversation_info_header));
        if (!this.isChangingConfigurations()) {
            HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(AnalyticsEventType.CONVERSATION_INFORMATION_OPENED);
        }
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__conversation_info_fragment, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        final String issuePublishId = this.getArguments().getString(BUNDLE_ARG_ISSUE_PUBLISH_ID);
        TextView publishIdView = (TextView)view.findViewById(R.id.issue_publish_id);
        final ImageButton copyButton = (ImageButton)view.findViewById(R.id.issue_id_copy_btn);
        Styles.setAccentColor(this.getContext(), copyButton.getDrawable());
        if (!TextUtils.isEmpty(issuePublishId)) {
            publishIdView.setText((CharSequence)this.getString(R.string.hs__conversation_info_id_format, new Object[]{issuePublishId}));
        }
        copyButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationInfoFragment.this.copyToClipboard(issuePublishId);
            }
        });
        copyButton.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                HSTooltip hsTooltip = new HSTooltip((View)copyButton, ConversationInfoFragment.this.getString(R.string.hs__copy_to_clipboard_tooltip));
                hsTooltip.show();
                return true;
            }
        });
    }

    @Override
    public boolean shouldRefreshMenu() {
        return true;
    }

    @Override
    public void onStop() {
        super.onStop();
        AppSessionConstants.Screen currentOpenScreen = (AppSessionConstants.Screen)IMAppSessionStorage.getInstance().get("current_open_screen");
        if (currentOpenScreen != null && currentOpenScreen.equals(screenType)) {
            IMAppSessionStorage.getInstance().removeKey("current_open_screen");
        }
    }
}

