/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.helpshift.R;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.support.adapters.FlowListAdapter;
import com.helpshift.support.controllers.SupportController;
import com.helpshift.support.flows.ConversationFlow;
import com.helpshift.support.flows.DynamicFormFlow;
import com.helpshift.support.flows.FAQSectionFlow;
import com.helpshift.support.flows.FAQsFlow;
import com.helpshift.support.flows.Flow;
import com.helpshift.support.flows.SingleFAQFlow;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.util.HelpshiftContext;
import java.util.List;

public class DynamicFormFragment
extends MainFragment
implements View.OnClickListener {
    private SupportController supportController;
    private RecyclerView flowListView;
    private List<Flow> flowList;
    private boolean sendAnalyticsEvent = true;
    public static final String FRAGMENT_TAG = "HSDynamicFormFragment";
    private String title;

    public static DynamicFormFragment newInstance(Bundle bundle, List<Flow> flowList, SupportController supportController) {
        DynamicFormFragment dynamicFormFragment = new DynamicFormFragment();
        dynamicFormFragment.setArguments(bundle);
        dynamicFormFragment.flowList = flowList;
        dynamicFormFragment.supportController = supportController;
        return dynamicFormFragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.title = bundle.getString("flow_title");
            if (TextUtils.isEmpty((CharSequence)this.title)) {
                this.title = this.getString(R.string.hs__help_header);
            }
        }
    }

    public void setSupportController(SupportController supportController) {
        this.supportController = supportController;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__dynamic_form_fragment, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.flowListView = (RecyclerView)view.findViewById(R.id.flow_list);
        this.flowListView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(view.getContext()));
    }

    public void onResume() {
        super.onResume();
        this.setToolbarTitle(this.title);
        this.showFlows();
    }

    private void showFlows() {
        if (this.flowList != null) {
            this.flowListView.setAdapter((RecyclerView.Adapter)new FlowListAdapter(this.flowList, this));
        }
    }

    public void onClick(View view) {
        int position = (Integer)view.getTag();
        Flow flow = this.flowList.get(position);
        this.sendAnalyticsEvent = false;
        this.performAction(flow);
    }

    private void performAction(Flow flow) {
        if (flow instanceof ConversationFlow) {
            ((ConversationFlow)flow).setSupportController(this.supportController);
        } else if (flow instanceof FAQSectionFlow) {
            ((FAQSectionFlow)flow).setSupportController(this.supportController);
        } else if (flow instanceof SingleFAQFlow) {
            ((SingleFAQFlow)flow).setSupportController(this.supportController);
        } else if (flow instanceof DynamicFormFlow) {
            ((DynamicFormFlow)flow).setSupportController(this.supportController);
        } else if (flow instanceof FAQsFlow) {
            ((FAQsFlow)flow).setSupportController(this.supportController);
        }
        flow.performAction();
    }

    @Override
    public void onStart() {
        super.onStart();
        if (!this.isChangingConfigurations() && this.sendAnalyticsEvent) {
            HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(AnalyticsEventType.DYNAMIC_FORM_OPEN);
        }
        this.sendAnalyticsEvent = true;
    }

    @Override
    public boolean shouldRefreshMenu() {
        return true;
    }

    @Override
    public void onStop() {
        super.onStop();
        if (!this.isChangingConfigurations() && this.sendAnalyticsEvent) {
            HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(AnalyticsEventType.DYNAMIC_FORM_CLOSE);
        }
    }
}

