/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.helpshift.R;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.support.Faq;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.HSApiData;
import com.helpshift.support.Section;
import com.helpshift.support.adapters.QuestionListAdapter;
import com.helpshift.support.contracts.FaqFlowViewParent;
import com.helpshift.support.contracts.FaqFragmentListener;
import com.helpshift.support.fragments.FaqFlowFragment;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.util.FragmentUtil;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;

public class QuestionListFragment
extends MainFragment {
    private static final String TAG = "Helpshift_QstnListFrag";
    private HSApiData data;
    private FaqTagFilter faqTagFilter;
    private String sectionTitle;
    private String sectionId;
    private RecyclerView questionList;
    private View.OnClickListener onQuestionClickedListener;
    private boolean eventSent = false;
    private boolean isConfigurationChanged = false;

    public static QuestionListFragment newInstance(Bundle bundle) {
        QuestionListFragment questionListFragment = new QuestionListFragment();
        questionListFragment.setArguments(bundle);
        return questionListFragment;
    }

    public FaqFragmentListener getFaqFlowListener() {
        return ((FaqFlowViewParent)this.getParentFragment()).getFaqFlowListener();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = this.getArguments();
        if (extras != null) {
            this.faqTagFilter = (FaqTagFilter)extras.getSerializable("withTagsMatching");
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__question_list_fragment, container, false);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.data = new HSApiData(context);
        this.sectionTitle = this.getString(R.string.hs__help_header);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        String sectionTile;
        super.onViewCreated(view, savedInstanceState);
        this.questionList = (RecyclerView)view.findViewById(R.id.question_list);
        this.questionList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(view.getContext()));
        this.onQuestionClickedListener = new View.OnClickListener(){

            public void onClick(View v) {
                String questionPublishId = (String)v.getTag();
                QuestionListFragment.this.getFaqFlowListener().onQuestionSelected(questionPublishId, null);
            }
        };
        String sectionPublishId = this.getArguments().getString("sectionPublishId");
        if (this.isScreenLarge() && !TextUtils.isEmpty((CharSequence)(sectionTile = this.getSectionTitle(sectionPublishId)))) {
            this.sectionTitle = sectionTile;
        }
        SectionSuccessHandler sectionSuccessHandler = new SectionSuccessHandler(this);
        SectionFailureHandler sectionFailHandler = new SectionFailureHandler(this);
        int supportMode = this.getArguments().getInt("support_mode", 0);
        switch (supportMode) {
            case 2: {
                this.data.getSection(sectionPublishId, sectionSuccessHandler, sectionFailHandler, this.faqTagFilter);
                break;
            }
            default: {
                this.data.getSectionSync(sectionPublishId, sectionSuccessHandler, sectionFailHandler);
            }
        }
        HSLogger.d(TAG, "FAQ section loaded : Name : " + this.sectionTitle);
    }

    void updateSectionData(Section section) {
        ArrayList<Faq> questions = this.data.getFaqsForSection(section.getPublishId(), this.faqTagFilter);
        if (questions == null || questions.isEmpty()) {
            if (!this.isDetached()) {
                SnackbarUtil.showErrorSnackbar(103, this.getView());
            }
        } else {
            this.questionList.setAdapter((RecyclerView.Adapter)new QuestionListAdapter(questions, this.onQuestionClickedListener));
            SupportFragment supportFragment = FragmentUtil.getSupportFragment(this);
            if (supportFragment != null) {
                supportFragment.onFaqsLoaded();
            }
            if (TextUtils.isEmpty((CharSequence)this.sectionId)) {
                this.getSectionId(this.getArguments().getString("sectionPublishId"));
            }
            this.pushAnalyticEvent();
        }
    }

    private String getSectionTitle(String sectionPublishId) {
        Section section = this.data.getSection(sectionPublishId);
        if (section != null) {
            return section.getTitle();
        }
        return null;
    }

    private void getSectionId(String sectionPublishId) {
        Section section = this.data.getSection(sectionPublishId);
        if (section != null) {
            this.sectionId = section.getSectionId();
        }
    }

    public void onResume() {
        super.onResume();
        this.setToolbarTitle(this.getString(R.string.hs__help_header));
        if (this.isScreenLarge()) {
            this.setToolbarTitle(this.sectionTitle);
            Fragment parent = this.getParentFragment();
            if (parent instanceof FaqFlowFragment) {
                ((FaqFlowFragment)parent).showVerticalDivider(true);
            }
        }
        this.pushAnalyticEvent();
    }

    @Override
    public void onStart() {
        super.onStart();
        this.isConfigurationChanged = this.isChangingConfigurations();
        this.eventSent = false;
    }

    @Override
    public boolean shouldRefreshMenu() {
        return this.getParentFragment() instanceof FaqFlowFragment;
    }

    public void onDestroyView() {
        SnackbarUtil.hideSnackbar(this.getView());
        super.onDestroyView();
    }

    @Override
    public void onStop() {
        if (this.isScreenLarge()) {
            this.setToolbarTitle(this.getString(R.string.hs__help_header));
        }
        super.onStop();
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        this.pushAnalyticEvent();
    }

    private void pushAnalyticEvent() {
        if (this.getUserVisibleHint() && !this.eventSent && !this.isConfigurationChanged && !TextUtils.isEmpty((CharSequence)this.sectionId)) {
            HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(AnalyticsEventType.BROWSED_FAQ_LIST, this.sectionId);
            this.eventSent = true;
        }
    }

    private static class SectionFailureHandler
    extends Handler {
        private final WeakReference<QuestionListFragment> questionListFragmentWeakReference;

        public SectionFailureHandler(QuestionListFragment fragment) {
            this.questionListFragmentWeakReference = new WeakReference<QuestionListFragment>(fragment);
        }

        public void handleMessage(Message msg) {
            QuestionListFragment questionListFragment = (QuestionListFragment)((Object)this.questionListFragmentWeakReference.get());
            if (questionListFragment != null && !questionListFragment.isDetached()) {
                Integer status = 103;
                if (msg.obj instanceof HashMap) {
                    HashMap result = (HashMap)msg.obj;
                    status = (Integer)result.get("status");
                }
                SnackbarUtil.showErrorSnackbar(status, questionListFragment.getView());
            }
        }
    }

    private static class SectionSuccessHandler
    extends Handler {
        private final WeakReference<QuestionListFragment> questionListFragmentWeakReference;

        public SectionSuccessHandler(QuestionListFragment fragment) {
            this.questionListFragmentWeakReference = new WeakReference<QuestionListFragment>(fragment);
        }

        public void handleMessage(Message msg) {
            QuestionListFragment questionListFragment = (QuestionListFragment)((Object)this.questionListFragmentWeakReference.get());
            if (questionListFragment != null && !questionListFragment.isDetached()) {
                if (msg.obj != null) {
                    Section section = (Section)msg.obj;
                    questionListFragment.updateSectionData(section);
                    HSLogger.d(QuestionListFragment.TAG, "FAQ section loaded : SectionSuccessHandler : " + section.getTitle());
                } else {
                    SnackbarUtil.showErrorSnackbar(103, questionListFragment.getView());
                }
            }
        }
    }
}

