/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.helpshift.R;
import com.helpshift.common.domain.AttachmentFileManagerDM;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.support.contracts.ScreenshotPreviewListener;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.storage.IMAppSessionStorage;
import com.helpshift.support.util.AppSessionConstants;
import com.helpshift.support.util.AttachmentUtil;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.util.HelpshiftContext;

public class ScreenshotPreviewFragment
extends MainFragment
implements View.OnClickListener,
AttachmentFileManagerDM.Listener {
    private ScreenshotPreviewListener screenshotPreviewListener;
    private int mode;
    private ImageView screenshotPreview;
    ImagePickerFile imagePickerFile;
    private Button secondaryButton;
    ProgressBar progressBar;
    private View buttonsContainer;
    private View buttonsSeparator;
    private static final AppSessionConstants.Screen screenType = AppSessionConstants.Screen.SCREENSHOT_PREVIEW;
    public static final String FRAGMENT_TAG = "ScreenshotPreviewFragment";
    private String attachmentMessageRefersId;
    LaunchSource launchSource;
    public static final String KEY_MESSAGE_REFERS_ID = "key_refers_id";
    public static final String KEY_SCREENSHOT_MODE = "key_screenshot_mode";

    public static ScreenshotPreviewFragment newInstance(ScreenshotPreviewListener listener) {
        ScreenshotPreviewFragment screenshotPreviewFragment = new ScreenshotPreviewFragment();
        screenshotPreviewFragment.screenshotPreviewListener = listener;
        return screenshotPreviewFragment;
    }

    public void setParams(@NonNull Bundle bundle, ImagePickerFile imagePickerFile, LaunchSource launchSource) {
        this.mode = bundle.getInt(KEY_SCREENSHOT_MODE);
        this.attachmentMessageRefersId = bundle.getString(KEY_MESSAGE_REFERS_ID);
        this.imagePickerFile = imagePickerFile;
        this.launchSource = launchSource;
        this.setScreenshotPreview();
    }

    public void setScreenshotPreviewListener(ScreenshotPreviewListener screenshotPreviewListener) {
        this.screenshotPreviewListener = screenshotPreviewListener;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__screenshot_preview_fragment, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.screenshotPreview = (ImageView)view.findViewById(R.id.screenshot_preview);
        Button changeButton = (Button)view.findViewById(R.id.change);
        changeButton.setOnClickListener((View.OnClickListener)this);
        this.secondaryButton = (Button)view.findViewById(R.id.secondary_button);
        this.secondaryButton.setOnClickListener((View.OnClickListener)this);
        this.progressBar = (ProgressBar)view.findViewById(R.id.screenshot_loading_indicator);
        this.buttonsContainer = view.findViewById(R.id.button_containers);
        this.buttonsSeparator = view.findViewById(R.id.buttons_separator);
    }

    @Override
    public void onStart() {
        super.onStart();
        IMAppSessionStorage.getInstance().set("current_open_screen", screenType);
    }

    @Override
    public boolean shouldRefreshMenu() {
        return true;
    }

    public void onResume() {
        super.onResume();
        ScreenshotPreviewFragment.setSecondaryButtonText(this.secondaryButton, this.mode);
        this.setScreenshotPreview();
        this.getView().setFocusableInTouchMode(true);
        this.getView().requestFocus();
        this.getView().setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 1 && keyCode == 4 && ScreenshotPreviewFragment.this.launchSource == LaunchSource.GALLERY_APP) {
                    HelpshiftContext.getCoreApi().getAttachmentFileManagerDM().deleteAttachmentLocalCopy(ScreenshotPreviewFragment.this.imagePickerFile);
                }
                return false;
            }
        });
    }

    @Override
    public void onStop() {
        super.onStop();
        AppSessionConstants.Screen currentOpenScreen = (AppSessionConstants.Screen)IMAppSessionStorage.getInstance().get("current_open_screen");
        if (currentOpenScreen != null && currentOpenScreen.equals(screenType)) {
            IMAppSessionStorage.getInstance().removeKey("current_open_screen");
        }
    }

    private static void setSecondaryButtonText(Button button, int mode) {
        String buttonText;
        Resources resources = button.getResources();
        switch (mode) {
            case 1: {
                buttonText = resources.getString(R.string.hs__screenshot_add);
                break;
            }
            case 2: {
                buttonText = resources.getString(R.string.hs__screenshot_remove);
                break;
            }
            case 3: {
                buttonText = resources.getString(R.string.hs__send_msg_btn);
                break;
            }
            default: {
                buttonText = "";
            }
        }
        button.setText((CharSequence)buttonText);
    }

    private void setScreenshotPreview() {
        if (this.isResumed()) {
            if (this.imagePickerFile == null) {
                if (this.screenshotPreviewListener != null) {
                    this.screenshotPreviewListener.removeScreenshotPreviewFragment();
                }
                return;
            }
            if (this.imagePickerFile.filePath != null) {
                this.renderScreenshotPreview(this.imagePickerFile.filePath);
            } else if (this.imagePickerFile.transientUri != null) {
                this.toggleProgressBarViewsVisibility(true);
                HelpshiftContext.getCoreApi().getAttachmentFileManagerDM().compressAndCopyScreenshot(this.imagePickerFile, this.attachmentMessageRefersId, this);
            }
        }
    }

    void renderScreenshotPreview(String filePath) {
        Bitmap screenshotBitmap = AttachmentUtil.getBitmap(filePath, -1);
        if (screenshotBitmap != null) {
            this.screenshotPreview.setImageBitmap(screenshotBitmap);
        } else if (this.screenshotPreviewListener != null) {
            this.screenshotPreviewListener.removeScreenshotPreviewFragment();
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.secondary_button && this.imagePickerFile != null) {
            switch (this.mode) {
                case 1: {
                    this.screenshotPreviewListener.addScreenshot(this.imagePickerFile);
                    break;
                }
                case 3: {
                    this.screenshotPreviewListener.sendScreenshot(this.imagePickerFile, this.attachmentMessageRefersId);
                    break;
                }
                case 2: {
                    HelpshiftContext.getCoreApi().getAttachmentFileManagerDM().deleteAttachmentLocalCopy(this.imagePickerFile);
                    this.screenshotPreviewListener.removeScreenshot();
                }
            }
        } else if (id2 == R.id.change) {
            if (this.mode == 2) {
                this.mode = 1;
            }
            HelpshiftContext.getCoreApi().getAttachmentFileManagerDM().deleteAttachmentLocalCopy(this.imagePickerFile);
            Bundle bundle = new Bundle();
            bundle.putInt(KEY_SCREENSHOT_MODE, this.mode);
            bundle.putString(KEY_MESSAGE_REFERS_ID, this.attachmentMessageRefersId);
            this.screenshotPreviewListener.changeScreenshot(bundle);
        }
    }

    @Override
    public void onCompressAndCopyFailure(RootAPIException e) {
        if (this.getActivity() != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ScreenshotPreviewFragment.this.progressBar.setVisibility(8);
                    SnackbarUtil.showSnackbar(ScreenshotPreviewFragment.this.getView(), R.string.hs__screenshot_cloud_attach_error, -2);
                }
            });
        }
    }

    @Override
    public void onPause() {
        SnackbarUtil.hideSnackbar(this.getView());
        super.onPause();
    }

    @Override
    public void onCompressAndCopySuccess(final ImagePickerFile imagePickerFile) {
        if (this.getActivity() != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ScreenshotPreviewFragment.this.toggleProgressBarViewsVisibility(false);
                    ScreenshotPreviewFragment.this.renderScreenshotPreview(imagePickerFile.filePath);
                }
            });
        }
    }

    void toggleProgressBarViewsVisibility(boolean visible) {
        if (visible) {
            this.progressBar.setVisibility(0);
            this.buttonsContainer.setVisibility(8);
            this.buttonsSeparator.setVisibility(8);
            this.screenshotPreview.setVisibility(8);
        } else {
            this.progressBar.setVisibility(8);
            this.buttonsContainer.setVisibility(0);
            this.buttonsSeparator.setVisibility(0);
            this.screenshotPreview.setVisibility(0);
        }
    }

    public static enum LaunchSource {
        ATTACHMENT_DRAFT,
        GALLERY_APP;

    }

    public static enum ScreenshotAction {
        ADD,
        SEND,
        REMOVE,
        CHANGE;

    }

    public static class Modes {
        public static final int ADD = 1;
        public static final int REMOVE = 2;
        public static final int SEND = 3;
    }
}

