/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.helpshift.R;
import com.helpshift.support.Faq;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSSearch;
import com.helpshift.support.adapters.SearchListAdapter;
import com.helpshift.support.contracts.FaqFlowViewParent;
import com.helpshift.support.contracts.FaqFragmentListener;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SearchFragment
extends MainFragment {
    private static final String KEY_SEARCH_QUERY = "key_search_query";
    public static final String TAG = "Helpshift_SearchFrag";
    HSApiData data;
    FaqTagFilter faqTagFilter;
    RecyclerView searchList;
    private View.OnClickListener onQuestionClickedListener;
    private View.OnClickListener onContactUsClickedListener;
    String currentQuery;
    private String sectionId;
    private final Handler searchResultSuccessHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg == null || msg.getData() == null || msg.obj == null) {
                return;
            }
            Bundle bundle = msg.getData();
            String searchQuery = bundle.getString(SearchFragment.KEY_SEARCH_QUERY);
            if (SearchFragment.this.currentQuery != null && SearchFragment.this.currentQuery.equals(searchQuery)) {
                ArrayList<Faq> searchResult = (ArrayList<Faq>)msg.obj;
                if (searchResult == null) {
                    searchResult = new ArrayList<Faq>();
                }
                SearchFragment.this.updateSearchResult(searchResult);
            }
        }
    };

    public static SearchFragment newInstance(Bundle bundle) {
        SearchFragment searchFragment = new SearchFragment();
        searchFragment.setArguments(bundle);
        return searchFragment;
    }

    public FaqFragmentListener getFaqFlowListener() {
        return ((FaqFlowViewParent)this.getParentFragment()).getFaqFlowListener();
    }

    public String getCurrentQuery() {
        return this.currentQuery;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = this.getArguments();
        if (extras != null) {
            this.faqTagFilter = (FaqTagFilter)extras.getSerializable("withTagsMatching");
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__search_fragment, container, false);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.data = new HSApiData(context);
        this.data.loadIndex();
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.searchList = (RecyclerView)view.findViewById(R.id.search_list);
        this.searchList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(view.getContext()));
        this.onQuestionClickedListener = new View.OnClickListener(){

            public void onClick(View v) {
                String questionPublishId = (String)v.getTag();
                ArrayList<String> searchTerms = null;
                Faq faq = ((SearchListAdapter)SearchFragment.this.searchList.getAdapter()).getFaq(questionPublishId);
                if (faq != null) {
                    searchTerms = faq.searchTerms;
                }
                SearchFragment.this.getFaqFlowListener().onQuestionSelected(questionPublishId, searchTerms);
            }
        };
        this.onContactUsClickedListener = new View.OnClickListener(){

            public void onClick(View v) {
                SearchFragment.this.getFaqFlowListener().onContactUsClicked(SearchFragment.this.currentQuery);
            }
        };
        if (this.getArguments() != null) {
            this.sectionId = this.getArguments().getString("sectionPublishId");
        }
        this.onQuery(this.currentQuery, this.sectionId);
    }

    @Override
    public boolean shouldRefreshMenu() {
        return true;
    }

    public void onQuery(String query, String sectionId) {
        this.sectionId = sectionId;
        if (this.searchList == null) {
            return;
        }
        boolean searchWithAny = false;
        String currentLang = HelpshiftContext.getCoreApi().getSDKConfigurationDM().getString("sdkLanguage");
        if (TextUtils.isEmpty((CharSequence)currentLang)) {
            currentLang = Locale.getDefault().getLanguage();
        }
        if (currentLang.startsWith("zh") || currentLang.equals("ja") || currentLang.equals("ko")) {
            searchWithAny = true;
        }
        query = query == null ? "" : query.trim();
        this.currentQuery = query;
        SearchResultFetcherTask runnable = new SearchResultFetcherTask(query, searchWithAny, sectionId, this.searchResultSuccessHandler);
        Thread searchResultFetcherThread = new Thread((Runnable)runnable, "HS-search-query");
        searchResultFetcherThread.start();
        HSLogger.d(TAG, "Performing search : Query : " + this.currentQuery);
    }

    public int getNumberOfSearchResults() {
        int numberOfSearchResults = -1;
        SearchListAdapter adapter = (SearchListAdapter)this.searchList.getAdapter();
        if (adapter != null) {
            numberOfSearchResults = adapter.getItemCount() - adapter.getFooterCount();
        }
        return numberOfSearchResults;
    }

    void updateSearchResult(@NonNull List<Faq> searchResult) {
        SearchListAdapter searchListAdapter = new SearchListAdapter(this.currentQuery, searchResult, this.onQuestionClickedListener, this.onContactUsClickedListener);
        searchListAdapter.setHasStableIds(true);
        if (this.searchList.getAdapter() == null) {
            this.searchList.setAdapter((RecyclerView.Adapter)searchListAdapter);
        } else {
            this.searchList.swapAdapter((RecyclerView.Adapter)new SearchListAdapter(this.currentQuery, searchResult, this.onQuestionClickedListener, this.onContactUsClickedListener), true);
        }
    }

    private class SearchResultFetcherTask
    implements Runnable {
        private String query;
        private boolean searchWithAny;
        private String sectionId;
        private Handler callback;

        public SearchResultFetcherTask(String query, boolean searchWithAny, String sectionId, Handler callback) {
            this.query = query;
            this.searchWithAny = searchWithAny;
            this.sectionId = sectionId;
            this.callback = callback;
        }

        @Override
        public void run() {
            List<Faq> searchResult = TextUtils.isEmpty((CharSequence)this.query) || this.query.length() < 3 && !this.searchWithAny ? SearchFragment.this.data.getAllFaqs(SearchFragment.this.faqTagFilter) : SearchFragment.this.data.localFaqSearch(this.query, HSSearch.HS_SEARCH_OPTIONS.FULL_SEARCH, SearchFragment.this.faqTagFilter);
            if (!TextUtils.isEmpty((CharSequence)this.sectionId)) {
                ArrayList<Faq> sectionResults = new ArrayList<Faq>();
                for (Faq question : searchResult) {
                    if (!question.section_publish_id.equals(this.sectionId)) continue;
                    sectionResults.add(question);
                }
                searchResult = sectionResults;
            }
            Message message = new Message();
            message.obj = searchResult;
            Bundle bundle = new Bundle();
            bundle.putString(SearchFragment.KEY_SEARCH_QUERY, this.query);
            message.setData(bundle);
            this.callback.sendMessage(message);
        }
    }
}

