/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.helpshift.R;
import com.helpshift.support.Faq;
import com.helpshift.support.adapters.SearchResultAdapter;
import com.helpshift.support.contracts.SearchResultListener;
import com.helpshift.support.fragments.MainFragment;
import java.util.ArrayList;
import java.util.List;

public class SearchResultFragment
extends MainFragment {
    SearchResultListener searchResultListener;
    RecyclerView searchResultList;
    private View.OnClickListener onQuestionClickedListener;
    private View.OnClickListener sendAnywayClickedListener;
    public static final String FRAGMENT_TAG = "HSSearchResultFragment";
    public static final String BUNDLE_ARG_SEARCH_RESULTS = "search_fragment_results";

    public static SearchResultFragment newInstance(Bundle bundle, SearchResultListener listener) {
        SearchResultFragment searchResultFragment = new SearchResultFragment();
        searchResultFragment.setArguments(bundle);
        searchResultFragment.searchResultListener = listener;
        return searchResultFragment;
    }

    public void setSearchResultListener(SearchResultListener searchResultListener) {
        this.searchResultListener = searchResultListener;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__search_result_fragment, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.searchResultList = (RecyclerView)view.findViewById(R.id.search_result);
        this.searchResultList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(view.getContext()));
        this.onQuestionClickedListener = new View.OnClickListener(){

            public void onClick(View v) {
                String questionPublishId = (String)v.getTag();
                ArrayList<String> searchTerms = null;
                Faq faq = ((SearchResultAdapter)SearchResultFragment.this.searchResultList.getAdapter()).getFaq(questionPublishId);
                if (faq != null) {
                    searchTerms = faq.searchTerms;
                }
                SearchResultFragment.this.searchResultListener.onQuestionSelected(questionPublishId, searchTerms);
            }
        };
        this.sendAnywayClickedListener = new View.OnClickListener(){

            public void onClick(View v) {
                SearchResultFragment.this.searchResultListener.sendAnyway();
            }
        };
    }

    public void onResume() {
        super.onResume();
        this.setToolbarTitle(this.getString(R.string.hs__search_result_title));
        this.showResults();
    }

    private void showResults() {
        int resultSize = 3;
        List results = this.getArguments().getParcelableArrayList(BUNDLE_ARG_SEARCH_RESULTS);
        if (results != null && results.size() > resultSize) {
            results = results.subList(0, resultSize);
        }
        SearchResultAdapter searchResultAdapter = new SearchResultAdapter(results, this.onQuestionClickedListener, this.sendAnywayClickedListener);
        this.searchResultList.setAdapter((RecyclerView.Adapter)searchResultAdapter);
    }

    @Override
    public boolean shouldRefreshMenu() {
        return true;
    }
}

