/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.model;

import java.util.Locale;

public final class AttachmentFileSize {
    private static final String FILE_SIZE_UNIT_MB = " MB";
    private static final String FILE_SIZE_UNIT_KB = " KB";
    private static final String FILE_SIZE_UNIT_B = " B";
    private double fileSize;
    private String fileSizeUnit;

    public AttachmentFileSize(double fileSizeInBytes) {
        if (fileSizeInBytes < 1024.0) {
            this.fileSize = fileSizeInBytes;
            this.fileSizeUnit = FILE_SIZE_UNIT_B;
        } else if (fileSizeInBytes < 1048576.0) {
            this.fileSize = fileSizeInBytes / 1024.0;
            this.fileSizeUnit = FILE_SIZE_UNIT_KB;
        } else {
            this.fileSize = fileSizeInBytes / 1048576.0;
            this.fileSizeUnit = FILE_SIZE_UNIT_MB;
        }
    }

    public String getFormattedFileSize() {
        String formattedFileSize = this.fileSizeUnit.equals(FILE_SIZE_UNIT_MB) ? String.format(Locale.US, "%.1f", this.fileSize) + this.fileSizeUnit : String.format(Locale.US, "%.0f", this.fileSize) + this.fileSizeUnit;
        return formattedFileSize;
    }
}

