/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.network.dataproviders;

import android.os.Build;
import android.text.TextUtils;
import com.helpshift.logger.model.LogModel;
import com.helpshift.providers.CrossModuleDataProvider;
import com.helpshift.providers.ICampaignsDataProvider;
import com.helpshift.support.HSStorage;
import com.helpshift.util.HSFormat;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.TimeUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ErrorLogRequestData {
    public static HashMap getRequestData(HSStorage storage, List<LogModel> logs, String profileId, String domain, String hsNetworkApiVersion) {
        JSONArray reportsJsonArray = new JSONArray();
        for (LogModel log : logs) {
            try {
                JSONObject logJson = new JSONObject();
                logJson.put("dt", (Object)log.timeStamp);
                logJson.put("l", (Object)log.level);
                logJson.put("ct", (Object)log.extras);
                logJson.put("msg", (Object)log.message);
                logJson.put("st", (Object)log.stacktrace);
                reportsJsonArray.put((Object)logJson);
            }
            catch (JSONException logJson) {}
        }
        JSONArray metadata = new JSONArray();
        try {
            JSONObject domainJSON = new JSONObject();
            domainJSON.put("domain", (Object)domain);
            metadata.put((Object)domainJSON);
        }
        catch (JSONException domainJSON) {
            // empty catch block
        }
        try {
            JSONObject deviceModelJSON = new JSONObject();
            deviceModelJSON.put("dm", (Object)Build.MODEL);
            metadata.put((Object)deviceModelJSON);
        }
        catch (JSONException deviceModelJSON) {
            // empty catch block
        }
        try {
            if (!TextUtils.isEmpty((CharSequence)profileId)) {
                JSONObject userIdJSON = new JSONObject();
                userIdJSON.put("profId", (Object)profileId);
                metadata.put((Object)userIdJSON);
            }
        }
        catch (JSONException userIdJSON) {
            // empty catch block
        }
        try {
            ICampaignsDataProvider campaignsDataProvider = CrossModuleDataProvider.getCampaignsDataProvider();
            if (campaignsDataProvider != null) {
                String did = campaignsDataProvider.getDeviceIdentifier();
                String uid = campaignsDataProvider.getUserIdentifier();
                if (!TextUtils.isEmpty((CharSequence)did)) {
                    JSONObject campaignsDeviceIdJSON = new JSONObject();
                    campaignsDeviceIdJSON.put("did", (Object)did);
                    metadata.put((Object)campaignsDeviceIdJSON);
                }
                if (!TextUtils.isEmpty((CharSequence)uid)) {
                    JSONObject campaignsUserIdJSON = new JSONObject();
                    campaignsUserIdJSON.put("uid", (Object)uid);
                    metadata.put((Object)campaignsUserIdJSON);
                }
            }
        }
        catch (JSONException campaignsDataProvider) {
            // empty catch block
        }
        try {
            JSONObject osVersionJson = new JSONObject();
            osVersionJson.put("os", (Object)Build.VERSION.RELEASE);
            metadata.put((Object)osVersionJson);
        }
        catch (JSONException osVersionJson) {
            // empty catch block
        }
        HashMap<String, String> hashMapData = new HashMap<String, String>();
        hashMapData.put("id", UUID.randomUUID().toString());
        hashMapData.put("v", hsNetworkApiVersion);
        float serverTimeDelta = HelpshiftContext.getPlatform().getNetworkRequestDAO().getServerTimeDelta();
        hashMapData.put("ctime", HSFormat.errorLogReportingTimeFormat.format(new Date(TimeUtil.getAdjustedTimeInMillis(Float.valueOf(serverTimeDelta)))));
        hashMapData.put("src", "sdk.android.6.3.0");
        hashMapData.put("md", metadata.toString());
        hashMapData.put("logs", reportsJsonArray.toString());
        return hashMapData;
    }
}

