/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.search.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.Nullable;
import com.helpshift.support.search.SearchTokenDao;
import com.helpshift.support.search.SearchTokenDto;
import com.helpshift.support.search.storage.SearchDBHelper;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchTokenDaoImpl
implements SearchTokenDao {
    private static final String TAG = "Helpshift_SearchToknDao";
    private static SQLiteOpenHelper dbHelper;
    private static final char scoreMapStringSeparator = '$';
    private static final char scoreMapKeyValueStringSeparator = ':';

    SearchTokenDaoImpl() {
        dbHelper = new SearchDBHelper(HelpshiftContext.getApplicationContext());
    }

    public static SearchTokenDao getInstance() {
        return LazyHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(List<SearchTokenDto> searchTokenList) {
        if (searchTokenList == null) {
            return;
        }
        ArrayList<ContentValues> contentValuesList = new ArrayList<ContentValues>();
        for (SearchTokenDto searchToken : searchTokenList) {
            String score = this.convertScoreMapToScoreString(searchToken.scoreMap);
            ContentValues searchTokenValues = new ContentValues();
            searchTokenValues.put("token", searchToken.wordValue);
            searchTokenValues.put("type", Integer.valueOf(searchToken.wordType));
            searchTokenValues.put("score", score);
            contentValuesList.add(searchTokenValues);
        }
        SQLiteDatabase db = null;
        SQLiteOpenHelper sQLiteOpenHelper = dbHelper;
        synchronized (sQLiteOpenHelper) {
            try {
                db = dbHelper.getWritableDatabase();
                db.beginTransaction();
                for (ContentValues contentValues : contentValuesList) {
                    db.insert("search_token_table", null, contentValues);
                }
                db.setTransactionSuccessful();
            }
            catch (Exception ex) {
                HSLogger.e(TAG, "Error occurred when calling save method", ex);
            }
            finally {
                try {
                    if (db != null && db.inTransaction()) {
                        db.endTransaction();
                    }
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error occurred when calling save method inside finally block", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SearchTokenDto get(String key) {
        SearchTokenDto searchToken = null;
        Cursor tokenCursor = null;
        SQLiteOpenHelper sQLiteOpenHelper = dbHelper;
        synchronized (sQLiteOpenHelper) {
            try {
                SQLiteDatabase db = dbHelper.getWritableDatabase();
                String[] projection = new String[]{"token", "type", "score"};
                tokenCursor = db.query("search_token_table", projection, "token=?", new String[]{key}, null, null, null);
                if (tokenCursor.getCount() > 0) {
                    tokenCursor.moveToFirst();
                    String value = tokenCursor.getString(tokenCursor.getColumnIndexOrThrow("token"));
                    int type = tokenCursor.getInt(tokenCursor.getColumnIndexOrThrow("type"));
                    String scoreString = tokenCursor.getString(tokenCursor.getColumnIndexOrThrow("score"));
                    Map<Integer, Double> scoreMap = this.convertScoreStringToScoreMap(scoreString);
                    searchToken = new SearchTokenDto(value, type, scoreMap);
                }
            }
            catch (Exception ex) {
                HSLogger.e(TAG, "Error occurred when calling get method", ex);
            }
            finally {
                if (tokenCursor != null) {
                    tokenCursor.close();
                }
            }
        }
        return searchToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        SQLiteOpenHelper sQLiteOpenHelper = dbHelper;
        synchronized (sQLiteOpenHelper) {
            try {
                SQLiteDatabase db = dbHelper.getWritableDatabase();
                db.delete("search_token_table", null, null);
            }
            catch (Exception ex) {
                HSLogger.e(TAG, "Error occurred when calling clear method", ex);
            }
        }
    }

    private String convertScoreMapToScoreString(Map<Integer, Double> scoreMap) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Integer key : scoreMap.keySet()) {
            if (first) {
                first = false;
            } else {
                result.append('$');
            }
            result.append(key);
            result.append(':');
            result.append(scoreMap.get(key));
        }
        return result.toString();
    }

    private Map<Integer, Double> convertScoreStringToScoreMap(String scoreString) {
        HashMap<Integer, Double> result = new HashMap<Integer, Double>();
        if (scoreString == null) {
            return result;
        }
        String[] array = scoreString.split("[$]");
        for (int i = 0; i < array.length; ++i) {
            String[] keyValue;
            String keyValueString = array[i];
            if (keyValueString == null || keyValueString.length() <= 0 || (keyValue = keyValueString.split("[:]")) == null || keyValue.length != 2) continue;
            int key = Integer.valueOf(keyValue[0]);
            double value = Double.valueOf(keyValue[1]);
            result.put(key, value);
        }
        return result;
    }

    private static class LazyHolder {
        static final SearchTokenDao INSTANCE = new SearchTokenDaoImpl();

        private LazyHolder() {
        }
    }
}

