/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.search.tfidf;

import android.util.Pair;
import android.util.SparseArray;
import com.helpshift.support.HSSearch;
import com.helpshift.support.search.SearchTokenDao;
import com.helpshift.support.search.SearchTokenDto;
import com.helpshift.support.search.storage.SearchTokenDaoImpl;
import com.helpshift.support.search.tfidf.PageIndexTrieNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PageIndexTrie {
    private static final int BATCH_SIZE = 1000;
    private static final int MAX_TOKEN_SIZE = 50;
    private final int totalDocCount;
    private PageIndexTrieNode root;
    private List<SearchTokenDto> searchTokenList;
    private SearchTokenDao searchTokenDao;
    private static final int minNGramLength = 1;
    private static final int maxNGramLength = 10;

    public PageIndexTrie(int totalDocCount) {
        this.totalDocCount = totalDocCount;
        this.root = new PageIndexTrieNode('\u0000');
        this.searchTokenList = new ArrayList<SearchTokenDto>();
    }

    public void insert(String word, int wordType, int docId) {
        if (word == null || 50 < word.length()) {
            return;
        }
        int wordLength = word.length();
        PageIndexTrieNode crawl = this.root;
        for (int level = 0; level < wordLength; ++level) {
            char ch = word.charAt(level);
            PageIndexTrieNode pageIndexTrieNode = crawl.getChild(ch);
            if (pageIndexTrieNode == null) {
                pageIndexTrieNode = new PageIndexTrieNode(ch);
                crawl.addChild(pageIndexTrieNode);
            }
            crawl = pageIndexTrieNode;
            if (wordType == 50 || level <= 1 || level >= 10 || level + 1 == wordLength) continue;
            crawl.isWordEnd = true;
            int freq = level * HSSearch.calcFreq(level, wordType) / wordLength;
            crawl.addFrequency(docId, freq, wordType);
        }
        crawl.isWordEnd = true;
        int freq = HSSearch.calcFreq(wordLength, wordType);
        crawl.addFrequency(docId, freq, wordType);
    }

    public void createAndStoreTfIdfIndex() {
        this.searchTokenDao = SearchTokenDaoImpl.getInstance();
        char[] prefix = new char[50];
        for (PageIndexTrieNode pageIndexTrieNode : this.root.getChildren()) {
            this.createAndStoreTfIdfIndex(pageIndexTrieNode, prefix, 0);
        }
        if (this.searchTokenList.size() > 0) {
            this.searchTokenDao.save(this.searchTokenList);
        }
    }

    private void createAndStoreTfIdfIndex(PageIndexTrieNode pageIndexTrieNode, char[] prefix, int level) {
        if (pageIndexTrieNode == null) {
            return;
        }
        prefix[level] = pageIndexTrieNode.nodeValue;
        if (pageIndexTrieNode.isWordEnd) {
            SearchTokenDto searchToken = this.buildTfIdfIndex(new String(prefix, 0, level + 1), pageIndexTrieNode);
            this.searchTokenList.add(searchToken);
            if (this.searchTokenList.size() > 1000) {
                this.searchTokenDao.save(this.searchTokenList);
                this.searchTokenList.clear();
            }
        }
        List<PageIndexTrieNode> child = pageIndexTrieNode.getChildren();
        for (PageIndexTrieNode tmpPageIndexNode : child) {
            this.createAndStoreTfIdfIndex(tmpPageIndexNode, prefix, level + 1);
        }
        pageIndexTrieNode.resetChildren();
    }

    private SearchTokenDto buildTfIdfIndex(String word, PageIndexTrieNode pageIndexTrieNode) {
        int maxFreq = pageIndexTrieNode.getMaxFrequency();
        int docFrequencyCount = pageIndexTrieNode.getFaqAppearCount();
        HashMap<Integer, Double> documentTfIdfMap = new HashMap<Integer, Double>();
        SparseArray<Pair<Integer, Integer>> wordFreq = pageIndexTrieNode.getWordFrequencyMap();
        int wordTokenType = -1;
        for (int index = 0; index < wordFreq.size(); ++index) {
            int docId = wordFreq.keyAt(index);
            Pair pair = (Pair)wordFreq.valueAt(index);
            double tf = (double)((Integer)pair.first).intValue() / (double)maxFreq;
            double idf = Math.log10((double)this.totalDocCount / (double)docFrequencyCount);
            double score = tf * idf * (double)HSSearch.getTermWeight((Integer)pair.second);
            documentTfIdfMap.put(docId, score);
            wordTokenType = Math.max(wordTokenType, (Integer)pair.second);
        }
        pageIndexTrieNode.resetFrequency();
        SearchTokenDto searchToken = new SearchTokenDto(word, wordTokenType, documentTfIdfMap);
        return searchToken;
    }
}

