/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.search.tfidf;

import android.util.Pair;
import android.util.SparseArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PageIndexTrieNode
implements Serializable {
    public final char nodeValue;
    public boolean isWordEnd;
    private SparseArray<Pair<Integer, Integer>> wordFrequency;
    private List<PageIndexTrieNode> children;

    public PageIndexTrieNode(char ch) {
        this.nodeValue = ch;
        this.children = new ArrayList<PageIndexTrieNode>();
        this.wordFrequency = new SparseArray();
    }

    public List<PageIndexTrieNode> getChildren() {
        return this.children;
    }

    public PageIndexTrieNode getChild(char ch) {
        if (this.children != null) {
            for (PageIndexTrieNode pageIndexTrieNode : this.children) {
                if (pageIndexTrieNode.nodeValue != ch) continue;
                return pageIndexTrieNode;
            }
        }
        return null;
    }

    public int getFaqAppearCount() {
        return this.wordFrequency.size();
    }

    public SparseArray<Pair<Integer, Integer>> getWordFrequencyMap() {
        return this.wordFrequency;
    }

    public int getMaxFrequency() {
        int result = 0;
        for (int index = 0; index < this.wordFrequency.size(); ++index) {
            result = Math.max(result, (Integer)((Pair)this.wordFrequency.valueAt((int)index)).first);
        }
        return result;
    }

    public void addFrequency(int docId, int frequency, int wordType) {
        Pair pair = (Pair)this.wordFrequency.get(docId);
        if (pair == null) {
            pair = new Pair((Object)frequency, (Object)wordType);
        } else {
            int oldFrequency = (Integer)pair.first;
            int oldType = (Integer)pair.second;
            pair = new Pair((Object)(oldFrequency += frequency), (Object)oldType);
        }
        this.wordFrequency.put(docId, (Object)pair);
    }

    public void addChild(PageIndexTrieNode pageIndexTrieNode) {
        this.children.add(pageIndexTrieNode);
    }

    public void resetFrequency() {
        this.wordFrequency = null;
    }

    public void resetChildren() {
        this.children = null;
    }
}

