/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.helpshift.support.Faq;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.storage.FaqDAO;
import com.helpshift.support.storage.FaqsDBHelper;
import com.helpshift.util.DatabaseUtils;
import com.helpshift.util.HSJSONUtils;
import com.helpshift.util.HSLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FaqsDataSource
implements FaqDAO {
    private static final String TAG = "HelpShiftDebug";
    private final FaqsDBHelper dbHelper = FaqsDBHelper.getInstance();

    public static void addFaqsUnsafe(SQLiteDatabase database, String sectionPublishId, JSONArray faqs) {
        try {
            for (int j = 0; j < faqs.length(); ++j) {
                JSONObject faq = faqs.getJSONObject(j);
                database.insert("faqs", null, FaqsDataSource.faqToContentValues(sectionPublishId, faq));
            }
        }
        catch (JSONException e) {
            HSLogger.d(TAG, "addFaqsUnsafe", e);
        }
    }

    private static Faq cursorToFaq(Cursor cursor) {
        return new Faq(cursor.getLong(cursor.getColumnIndex("_id")), cursor.getString(cursor.getColumnIndex("question_id")), cursor.getString(cursor.getColumnIndex("publish_id")), cursor.getString(cursor.getColumnIndex("section_id")), cursor.getString(cursor.getColumnIndex("title")), cursor.getString(cursor.getColumnIndex("body")), cursor.getInt(cursor.getColumnIndex("helpful")), cursor.getInt(cursor.getColumnIndex("rtl")) == 1, HSJSONUtils.jsonToStringArrayList(cursor.getString(cursor.getColumnIndex("tags"))), HSJSONUtils.jsonToStringArrayList(cursor.getString(cursor.getColumnIndex("c_tags"))));
    }

    private static ContentValues faqToContentValues(Faq faq) {
        ContentValues values = new ContentValues();
        values.put("question_id", faq.getId());
        values.put("publish_id", faq.publish_id);
        values.put("section_id", faq.section_publish_id);
        values.put("title", faq.title);
        values.put("body", faq.body);
        values.put("helpful", Integer.valueOf(faq.is_helpful));
        values.put("rtl", faq.is_rtl);
        values.put("tags", String.valueOf(new JSONArray(faq.getTags())));
        values.put("c_tags", String.valueOf(new JSONArray(faq.getCategoryTags())));
        return values;
    }

    private static ContentValues faqToContentValues(String sectionPublishId, JSONObject faq) throws JSONException {
        ContentValues values = new ContentValues();
        values.put("question_id", faq.getString("id"));
        values.put("publish_id", faq.getString("publish_id"));
        values.put("section_id", sectionPublishId);
        values.put("title", faq.getString("title"));
        values.put("body", faq.getString("body"));
        values.put("helpful", Integer.valueOf(0));
        values.put("rtl", Boolean.valueOf(faq.getString("is_rtl").equals("true")));
        values.put("tags", faq.has("stags") ? faq.optJSONArray("stags").toString() : new JSONArray().toString());
        values.put("c_tags", faq.has("issue_tags") ? faq.optJSONArray("issue_tags").toString() : new JSONArray().toString());
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDB() {
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            try {
                SQLiteDatabase database = this.dbHelper.getWritableDatabase();
                this.dbHelper.clearDatabase(database);
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error in clearDB", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFaq(Faq faq) {
        ContentValues values = FaqsDataSource.faqToContentValues(faq);
        String whereClause = "question_id=?";
        String[] whereArgs = new String[]{faq.getId()};
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            try {
                SQLiteDatabase database = this.dbHelper.getWritableDatabase();
                if (!DatabaseUtils.exists(database, "faqs", whereClause, whereArgs)) {
                    database.insert("faqs", null, values);
                } else {
                    database.update("faqs", values, whereClause, whereArgs);
                }
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error in addFaq", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFaq(String publishId) {
        if (!TextUtils.isEmpty((CharSequence)publishId)) {
            FaqsDBHelper faqsDBHelper = this.dbHelper;
            synchronized (faqsDBHelper) {
                try {
                    String whereClause = "publish_id=?";
                    String[] whereArgs = new String[]{publishId};
                    SQLiteDatabase database = this.dbHelper.getWritableDatabase();
                    database.delete("faqs", whereClause, whereArgs);
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error in removeFaq", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Faq getFaq(String publishId) {
        if (TextUtils.isEmpty((CharSequence)publishId)) {
            return new Faq();
        }
        Faq faq = null;
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            try (Cursor cursor = null;){
                SQLiteDatabase database = this.dbHelper.getReadableDatabase();
                cursor = database.query("faqs", null, "publish_id = ?", new String[]{publishId}, null, null, null);
                if (cursor.moveToFirst()) {
                    faq = FaqsDataSource.cursorToFaq(cursor);
                }
            }
        }
        return faq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Faq> getFaqsDataForSection(String sectionPublishId) {
        if (TextUtils.isEmpty((CharSequence)sectionPublishId)) {
            return new ArrayList<Faq>();
        }
        ArrayList<Faq> faqs = new ArrayList<Faq>();
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            try (Cursor cursor = null;){
                SQLiteDatabase database = this.dbHelper.getReadableDatabase();
                cursor = database.query("faqs", null, "section_id = ?", new String[]{sectionPublishId}, null, null, null);
                if (cursor.moveToFirst()) {
                    while (!cursor.isAfterLast()) {
                        Faq faq = FaqsDataSource.cursorToFaq(cursor);
                        faqs.add(faq);
                        cursor.moveToNext();
                    }
                }
            }
        }
        return faqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllFaqPublishIds() {
        ArrayList<String> faqPublishIds = new ArrayList<String>();
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            try (Cursor cursor = null;){
                String[] columns = new String[]{"publish_id"};
                SQLiteDatabase database = this.dbHelper.getReadableDatabase();
                cursor = database.query("faqs", columns, null, null, null, null, null);
                if (cursor.moveToFirst()) {
                    while (!cursor.isAfterLast()) {
                        String publishIds = cursor.getString(cursor.getColumnIndex("publish_id"));
                        faqPublishIds.add(publishIds);
                        cursor.moveToNext();
                    }
                }
            }
        }
        return faqPublishIds;
    }

    @Override
    public List<Faq> getFilteredFaqs(List<Faq> faqs, FaqTagFilter faqTagFilter) {
        if (faqTagFilter == null) {
            return faqs;
        }
        switch (faqTagFilter.getOperator()) {
            case "and": {
                return this.getANDFilteredFaqs(faqs, faqTagFilter);
            }
            case "or": {
                return this.getORFilteredFaqs(faqs, faqTagFilter);
            }
            case "not": {
                return this.getNOTFilteredFaqs(faqs, faqTagFilter);
            }
            case "undefined": {
                return faqs;
            }
        }
        return faqs;
    }

    @Override
    public List<Faq> getFaqsForSection(String sectionPublishId, FaqTagFilter faqTagFilter) {
        List<Faq> faqsForSection = this.getFaqsDataForSection(sectionPublishId);
        return this.getFilteredFaqs(faqsForSection, faqTagFilter);
    }

    private List<Faq> getANDFilteredFaqs(List<Faq> faqs, FaqTagFilter faqTagFilter) {
        ArrayList<Faq> filteredFaqs = new ArrayList<Faq>();
        for (Faq faq : faqs) {
            ArrayList<String> filterTags = new ArrayList<String>(Arrays.asList(faqTagFilter.getTags()));
            List<String> categoryTags = faq.getCategoryTags();
            filterTags.removeAll(categoryTags);
            if (!filterTags.isEmpty()) continue;
            filteredFaqs.add(faq);
        }
        return filteredFaqs;
    }

    private List<Faq> getORFilteredFaqs(List<Faq> faqs, FaqTagFilter faqTagFilter) {
        ArrayList<Faq> filteredFaqs = new ArrayList<Faq>();
        for (Faq faq : faqs) {
            List<String> categoryTags;
            ArrayList<String> filterTags = new ArrayList<String>(Arrays.asList(faqTagFilter.getTags()));
            if (!filterTags.removeAll(categoryTags = faq.getCategoryTags())) continue;
            filteredFaqs.add(faq);
        }
        return filteredFaqs;
    }

    private List<Faq> getNOTFilteredFaqs(List<Faq> faqs, FaqTagFilter faqTagFilter) {
        ArrayList<Faq> filteredFaqs = new ArrayList<Faq>();
        for (Faq faq : faqs) {
            List<String> categoryTags;
            ArrayList<String> filterTags = new ArrayList<String>(Arrays.asList(faqTagFilter.getTags()));
            if (filterTags.removeAll(categoryTags = faq.getCategoryTags())) continue;
            filteredFaqs.add(faq);
        }
        return filteredFaqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setIsHelpful(String questionId, Boolean state) {
        int returnVal = 0;
        if (TextUtils.isEmpty((CharSequence)questionId)) {
            return returnVal;
        }
        ContentValues values = new ContentValues();
        values.put("helpful", Integer.valueOf(state != false ? 1 : -1));
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            try {
                SQLiteDatabase database = this.dbHelper.getWritableDatabase();
                returnVal = database.update("faqs", values, "question_id = ?", new String[]{questionId});
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error in setIsHelpful", e);
            }
        }
        return returnVal;
    }
}

