/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import com.helpshift.storage.KeyValueStorage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class IMAppSessionStorage
implements KeyValueStorage {
    private Map<String, Serializable> sessionStorage = new HashMap<String, Serializable>();
    private Lock readLock;
    private Lock writeLock;

    IMAppSessionStorage() {
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.readLock = reentrantReadWriteLock.readLock();
        this.writeLock = reentrantReadWriteLock.writeLock();
    }

    public static IMAppSessionStorage getInstance() {
        return LazyHolder.INSTANCE;
    }

    @Override
    public boolean set(String key, Serializable value) {
        if (key == null) {
            return false;
        }
        this.writeLock.lock();
        Serializable retValue = this.sessionStorage.put(key, value);
        this.writeLock.unlock();
        return retValue != null;
    }

    @Override
    public void setWithBackup(String key, Serializable value) {
        this.set(key, value);
    }

    @Override
    public Serializable get(String key) {
        if (key == null) {
            return null;
        }
        this.readLock.lock();
        Serializable value = this.sessionStorage.get(key);
        this.readLock.unlock();
        return value;
    }

    @Override
    public void removeKey(String key) {
        if (key == null) {
            return;
        }
        this.writeLock.lock();
        this.sessionStorage.remove(key);
        this.writeLock.unlock();
    }

    @Override
    public void removeAllKeys() {
        this.writeLock.lock();
        this.sessionStorage.clear();
        this.writeLock.unlock();
    }

    private static class LazyHolder {
        static final IMAppSessionStorage INSTANCE = new IMAppSessionStorage();

        private LazyHolder() {
        }
    }
}

