/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class ProfilesDBHelper
extends SQLiteOpenHelper {
    public static final String TABLE_PROFILES = "profiles";
    public static final String COLUMN_ID = "_id";
    public static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    public static final String COLUMN_PROFILE_ID = "profile_id";
    public static final String COLUMN_NAME = "name";
    public static final String COLUMN_EMAIL = "email";
    public static final String COLUMN_SALT = "salt";
    public static final String COLUMN_UID = "uid";
    public static final String COLUMN_DID = "did";
    public static final String COLUMN_PUSH_TOKEN_SYNC_STATUS = "push_token_sync";
    public static final String DATABASE_NAME = "__hs__db_profiles";
    private static final int DATABASE_VERSION = 3;
    private static final String DATABASE_CREATE = "CREATE TABLE profiles(_id INTEGER PRIMARY KEY AUTOINCREMENT, IDENTIFIER TEXT NOT NULL UNIQUE, profile_id TEXT UNIQUE, name TEXT, email TEXT, salt TEXT, uid TEXT, did TEXT, push_token_sync INTEGER );";
    private static final String ALTER_PROFILES_TABLE_ADD_USER_ID = "ALTER TABLE profiles ADD uid TEXT";
    private static final String ALTER_PROFILES_TABLE_ADD_DEVICE_ID = "ALTER TABLE profiles ADD did TEXT";
    private static final String ALTER_PROFILES_TABLE_ADD_PUSH_TOKEN_SYNC_STATUS = "ALTER TABLE profiles ADD push_token_sync INTEGER";

    public ProfilesDBHelper(Context context) {
        super(context, DATABASE_NAME, null, 3);
    }

    public void onCreate(SQLiteDatabase database) {
        database.execSQL(DATABASE_CREATE);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (db.isOpen()) {
            if (oldVersion < 2) {
                db.execSQL(ALTER_PROFILES_TABLE_ADD_USER_ID);
                db.execSQL(ALTER_PROFILES_TABLE_ADD_DEVICE_ID);
            }
            if (oldVersion < 3) {
                db.execSQL(ALTER_PROFILES_TABLE_ADD_PUSH_TOKEN_SYNC_STATUS);
            }
        }
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (db.isOpen()) {
            db.execSQL("DROP TABLE IF EXISTS profiles");
            this.onCreate(db);
        }
    }
}

