/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.helpshift.account.dao.ProfileDTO;
import com.helpshift.support.storage.ProfilesDBHelper;
import com.helpshift.util.DBUtil;
import com.helpshift.util.DatabaseUtils;
import com.helpshift.util.HSLogger;

public class ProfilesDataSource {
    private static final String TAG = "Helpshift_ProfileDB";
    private ProfilesDBHelper dbHelper;

    public ProfilesDataSource(Context context) {
        this.dbHelper = new ProfilesDBHelper(context);
    }

    public synchronized void addProfile(ProfileDTO profile) {
        String whereClause = "IDENTIFIER=?";
        String[] whereArgs = new String[]{profile.identifier};
        SQLiteDatabase database = this.dbHelper.getWritableDatabase();
        ContentValues values = this.profileToContentValues(profile);
        try {
            if (!DatabaseUtils.exists(database, "profiles", whereClause, whereArgs)) {
                database.insert("profiles", null, values);
            } else {
                database.update("profiles", values, whereClause, whereArgs);
            }
        }
        catch (Exception e) {
            HSLogger.e(TAG, "Error in addProfile", e);
        }
        DBUtil.backupDatabase("__hs__db_profiles");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ProfileDTO getProfile(String identifier) {
        ProfileDTO profile = null;
        try (Cursor cursor = null;){
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            String whereClause = "IDENTIFIER=?";
            String[] whereArgs = new String[]{identifier};
            cursor = database.query("profiles", null, whereClause, whereArgs, null, null, null);
            if (cursor.moveToFirst()) {
                profile = this.cursorToProfile(cursor);
            }
        }
        return profile;
    }

    private static int getColumnIndexForIdentifier(Cursor cursor) {
        int result = cursor.getColumnIndex("IDENTIFIER");
        if (result == -1) {
            result = cursor.getColumnIndex("IDENTIFIER".toLowerCase());
        }
        return result;
    }

    private ProfileDTO cursorToProfile(Cursor cursor) {
        return new ProfileDTO(cursor.getLong(cursor.getColumnIndex("_id")), cursor.getString(ProfilesDataSource.getColumnIndexForIdentifier(cursor)), cursor.getString(cursor.getColumnIndex("profile_id")), cursor.getString(cursor.getColumnIndex("name")), cursor.getString(cursor.getColumnIndex("email")), cursor.getString(cursor.getColumnIndex("salt")), cursor.getString(cursor.getColumnIndex("uid")), cursor.getString(cursor.getColumnIndex("did")), cursor.getInt(cursor.getColumnIndex("push_token_sync")) == 1);
    }

    private ContentValues profileToContentValues(ProfileDTO profile) {
        ContentValues values = new ContentValues();
        values.put("IDENTIFIER", profile.identifier);
        values.put("profile_id", profile.serverId);
        values.put("name", profile.name);
        values.put("email", profile.email);
        values.put("salt", profile.saltedIdentifier);
        values.put("uid", profile.uid);
        values.put("did", profile.did);
        values.put("push_token_sync", Boolean.valueOf(profile.isPushTokenSynced));
        return values;
    }
}

