/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import android.content.ContentResolver;
import android.provider.Settings;
import com.helpshift.account.dao.AccountManagerDAO;
import com.helpshift.account.dao.ProfileDAO;
import com.helpshift.account.dao.ProfileDTO;
import com.helpshift.common.StringUtils;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.NetworkRequestDAO;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.meta.dao.MetaDataDAO;
import com.helpshift.support.HSStorage;
import com.helpshift.support.util.ConfigUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONObject;

public class SupportKVStoreMigrator {
    private static final String TAG = "Helpshift_KVStoreMigratorr";
    private HSStorage hsStorage;
    private SDKConfigurationDM sdkConfigurationDM;
    private NetworkRequestDAO networkRequestDAO;
    private AccountManagerDAO accountManagerDAO;
    private ProfileDAO profileDAO;
    private MetaDataDAO metaDataDAO;
    private String loginIdentifier;
    private String defaultIdentifier;
    private ProfileDTO defaultProfileDto;
    private Boolean requireEmail;
    private Boolean fullPrivacy;
    private Boolean hideNameEmail;
    private Boolean showSearchOnNewConversation;
    private Boolean gotoConversationAfterContactUs;
    private Boolean showConversationResolutionQuestion;
    private Boolean showConversationInfoScreen;
    private Boolean enableTypingIndicator;
    private float serverTimeDelta;
    private HashMap<String, Serializable> customMetaData;

    public SupportKVStoreMigrator(HSStorage hsStorage) {
        this.hsStorage = hsStorage;
        this.sdkConfigurationDM = HelpshiftContext.getCoreApi().getSDKConfigurationDM();
        Platform platform = HelpshiftContext.getPlatform();
        this.networkRequestDAO = platform.getNetworkRequestDAO();
        this.accountManagerDAO = platform.getAccountManagerDAO();
        this.profileDAO = platform.getProfileDAO();
        this.metaDataDAO = platform.getMetaDataDAO();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void backup() {
        this.requireEmail = this.hsStorage.contains("requireEmail") ? this.hsStorage.storageGetBoolean("requireEmail") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("requireEmail"));
        this.fullPrivacy = this.hsStorage.contains("fullPrivacy") ? this.hsStorage.storageGetBoolean("fullPrivacy") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("fullPrivacy"));
        this.hideNameEmail = this.hsStorage.contains("hideNameAndEmail") ? this.hsStorage.storageGetBoolean("hideNameAndEmail") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("hideNameAndEmail"));
        this.showSearchOnNewConversation = this.hsStorage.contains("showSearchOnNewConversation") ? this.hsStorage.storageGetBoolean("showSearchOnNewConversation") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("showSearchOnNewConversation"));
        this.gotoConversationAfterContactUs = this.hsStorage.contains("gotoConversationAfterContactUs") ? this.hsStorage.storageGetBoolean("gotoConversationAfterContactUs") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("gotoConversationAfterContactUs"));
        this.showConversationResolutionQuestion = this.hsStorage.contains("showConversationResolutionQuestion") ? this.hsStorage.storageGetBoolean("showConversationResolutionQuestion") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("showConversationResolutionQuestion"));
        this.showConversationInfoScreen = this.hsStorage.contains("showConversationInfoScreen") ? this.hsStorage.storageGetBoolean("showConversationInfoScreen") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("showConversationInfoScreen"));
        this.enableTypingIndicator = this.hsStorage.contains("enableTypingIndicator") ? this.hsStorage.storageGetBoolean("enableTypingIndicator") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("enableTypingIndicator"));
        this.serverTimeDelta = this.hsStorage.contains("serverTimeDelta") ? this.hsStorage.storageGetFloat("serverTimeDelta").floatValue() : this.networkRequestDAO.getServerTimeDelta();
        this.loginIdentifier = this.hsStorage.contains("loginIdentifier") ? this.hsStorage.getString("loginIdentifier") : this.accountManagerDAO.getLoginId();
        String defaultUserServerId = null;
        if (this.hsStorage.contains("identity")) {
            defaultUserServerId = this.hsStorage.getString("identity");
        }
        if (!StringUtils.isEmpty(defaultUserServerId)) {
            this.defaultIdentifier = this.hsStorage.getString("uuid");
            if (StringUtils.isEmpty(this.defaultIdentifier)) {
                this.defaultIdentifier = Settings.Secure.getString((ContentResolver)HelpshiftContext.getApplicationContext().getContentResolver(), (String)"android_id");
            }
            String name = this.hsStorage.getString("username");
            String email = this.hsStorage.getString("email");
            String uid = this.hsStorage.getString("campaignsUid");
            String did = this.hsStorage.getString("campaignsDid");
            this.defaultProfileDto = new ProfileDTO(null, this.defaultIdentifier, defaultUserServerId, name, email, this.defaultIdentifier, uid, did, false);
        } else {
            this.defaultIdentifier = this.accountManagerDAO.getDefaultLoginId();
            if (!StringUtils.isEmpty(this.defaultIdentifier)) {
                this.defaultProfileDto = this.accountManagerDAO.readProfile(this.defaultIdentifier);
            }
        }
        if (this.hsStorage.contains("customMetaData")) {
            String metaString = this.hsStorage.getString("customMetaData");
            try {
                if (StringUtils.isEmpty(metaString)) return;
                JSONObject metaObj = new JSONObject(metaString);
                Iterator iterator = metaObj.keys();
                this.customMetaData = new HashMap();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Object value = metaObj.get(key);
                    if (!(value instanceof Serializable)) continue;
                    this.customMetaData.put(key, (Serializable)value);
                }
                return;
            }
            catch (Exception e) {
                HSLogger.d(TAG, "Exception converting meta from storage", e);
                return;
            }
        } else {
            this.customMetaData = this.metaDataDAO.getCustomMetaData();
        }
    }

    public void restore() {
        HashMap<String, Boolean> configEntriesToRestore = new HashMap<String, Boolean>();
        configEntriesToRestore.put("requireEmail", this.requireEmail);
        configEntriesToRestore.put("fullPrivacy", this.fullPrivacy);
        configEntriesToRestore.put("hideNameAndEmail", this.hideNameEmail);
        configEntriesToRestore.put("showSearchOnNewConversation", this.showSearchOnNewConversation);
        configEntriesToRestore.put("gotoConversationAfterContactUs", this.gotoConversationAfterContactUs);
        configEntriesToRestore.put("showConversationResolutionQuestion", this.showConversationResolutionQuestion);
        configEntriesToRestore.put("showConversationInfoScreen", this.showConversationInfoScreen);
        configEntriesToRestore.put("enableTypingIndicator", this.enableTypingIndicator);
        HashMap<String, Object> configMap = new HashMap<String, Object>(ConfigUtil.defaultApiConfig);
        configMap.putAll(configEntriesToRestore);
        HelpshiftContext.getCoreApi().updateApiConfig(configMap);
        this.networkRequestDAO.storeServerTimeDelta(this.serverTimeDelta);
        this.accountManagerDAO.saveLoginId(this.loginIdentifier);
        if (!StringUtils.isEmpty(this.defaultIdentifier)) {
            this.accountManagerDAO.saveDefaultLoginId(this.defaultIdentifier);
            if (this.defaultProfileDto != null) {
                this.profileDAO.insertOrUpdateProfile(this.defaultProfileDto);
            }
        }
        this.metaDataDAO.saveCustomMetaData(this.customMetaData);
    }
}

