/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import android.content.Context;
import com.helpshift.common.platform.KVStore;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.support.storage.SupportRetryKeyValueDBStorage;
import java.io.Serializable;

public class SupportKeyValueDBStorage
implements KVStore {
    private KeyValueStorage storage;

    public SupportKeyValueDBStorage(Context context) {
        this.storage = new SupportRetryKeyValueDBStorage(context);
    }

    @Override
    public void setBoolean(String key, Boolean value) {
        this.setOrRemoveKeyInternal(key, value);
    }

    @Override
    public void setInt(String key, Integer value) {
        this.setOrRemoveKeyInternal(key, value);
    }

    @Override
    public void setFloat(String key, Float value) {
        this.setOrRemoveKeyInternal(key, value);
    }

    @Override
    public void setString(String key, String value) {
        this.setOrRemoveKeyInternal(key, (Serializable)((Object)value));
    }

    @Override
    public void setSerializable(String key, Serializable value) {
        this.setOrRemoveKeyInternal(key, value);
    }

    @Override
    public Boolean getBoolean(String key) {
        Object value = this.storage.get(key);
        if (value == null) {
            return null;
        }
        return (Boolean)value;
    }

    @Override
    public Boolean getBoolean(String key, Boolean defValue) {
        Object value = this.storage.get(key);
        if (value == null) {
            return defValue;
        }
        return (Boolean)value;
    }

    @Override
    public Integer getInt(String key) {
        Object value = this.storage.get(key);
        if (value == null) {
            return null;
        }
        return (Integer)value;
    }

    @Override
    public Integer getInt(String key, Integer defValue) {
        Object value = this.storage.get(key);
        if (value == null) {
            return defValue;
        }
        return (Integer)value;
    }

    @Override
    public Float getFloat(String key) {
        Object value = this.storage.get(key);
        if (value == null) {
            return null;
        }
        return (Float)value;
    }

    @Override
    public Float getFloat(String key, Float defValue) {
        Object value = this.storage.get(key);
        if (value == null) {
            return defValue;
        }
        return (Float)value;
    }

    @Override
    public String getString(String key) {
        Object value = this.storage.get(key);
        if (value == null) {
            return null;
        }
        return (String)value;
    }

    @Override
    public String getString(String key, String defValue) {
        Object value = this.storage.get(key);
        if (value == null) {
            return defValue;
        }
        return (String)value;
    }

    @Override
    public Object getSerializable(String key) {
        Object value = this.storage.get(key);
        return value;
    }

    @Override
    public void removeAllKeys() {
        this.storage.removeAllKeys();
    }

    private void setOrRemoveKeyInternal(String key, Serializable value) {
        if (value == null) {
            this.storage.removeKey(key);
        } else {
            this.storage.set(key, value);
        }
    }
}

