/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import android.content.Context;
import com.helpshift.storage.BaseRetryKeyValueStorage;
import com.helpshift.storage.KeyValueDbStorage;
import com.helpshift.support.storage.SupportKeyValueDBStorageHelper;
import com.helpshift.util.HSLogger;
import java.io.File;

class SupportRetryKeyValueDBStorage
extends BaseRetryKeyValueStorage {
    private SupportKeyValueDBStorageHelper sqLiteOpenHelper;
    private final Context context;
    private static final String LOCK_FILE_NAME = "__hs_supportkvdb_lock";
    private final String lockFilePath;

    SupportRetryKeyValueDBStorage(Context context) {
        this.context = context;
        this.lockFilePath = context.getFilesDir() + File.separator + LOCK_FILE_NAME;
        this.sqLiteOpenHelper = new SupportKeyValueDBStorageHelper(context);
        this.keyValueStorage = new KeyValueDbStorage(this.sqLiteOpenHelper, null, this.lockFilePath);
    }

    @Override
    protected void reInitiateDbInstance() {
        try {
            if (this.sqLiteOpenHelper != null) {
                this.sqLiteOpenHelper.close();
            }
        }
        catch (Exception e) {
            HSLogger.e("Helpshift_RetryKeyValue", "Error in closing DB", e);
        }
        this.sqLiteOpenHelper = new SupportKeyValueDBStorageHelper(this.context);
        this.keyValueStorage = new KeyValueDbStorage(this.sqLiteOpenHelper, null, this.lockFilePath);
    }
}

