/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.support.HSApiData;
import com.helpshift.util.FileUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.ImageUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;

public final class AttachmentUtil {
    private static final String TAG = "Helpshift_AttachUtil";
    private static final int IMAGE_MAX_DIMENSION = 1024;

    public static Bitmap getBitmap(String path, int dstWidth) {
        int exifRotation;
        if (!AttachmentUtil.doesFilePathExistAndCanRead(path)) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        if (dstWidth > 0) {
            float ratio = (float)options.outHeight / (float)options.outWidth;
            int dstHeight = (int)(ratio * (float)dstWidth);
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
            options.inSampleSize = ImageUtil.calculateInSampleSize(options, dstWidth, dstHeight);
        } else {
            options.inSampleSize = 4;
        }
        if (options.inSampleSize < 4) {
            ++options.inSampleSize;
        }
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        if (bitmap != null && (exifRotation = AttachmentUtil.getExifRotation(path)) != 0) {
            Matrix matrix = new Matrix();
            matrix.preRotate((float)exifRotation);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
        }
        return bitmap;
    }

    private static boolean doesFilePathExistAndCanRead(String filePath) {
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            File file = new File(filePath);
            return file.exists() && file.canRead();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyAttachment(String filename, String messageId) throws IOException {
        Context context = HelpshiftContext.getApplicationContext();
        HSApiData hsApiData = new HSApiData(context);
        InputStream input = null;
        FileOutputStream output = null;
        String fileExtension = FileUtil.getFileExtension(filename);
        try {
            String outputName = AttachmentUtil.buildLocalAttachmentCopyFileName(messageId, fileExtension);
            File outputFile = new File(context.getFilesDir(), outputName);
            String fname = outputFile.getAbsolutePath();
            if (!outputFile.exists()) {
                int read;
                hsApiData.storeFile(outputName);
                input = new FileInputStream(new File(filename));
                output = context.openFileOutput(outputName, 0);
                byte[] data = new byte[1024];
                while ((read = input.read(data)) != -1) {
                    output.write(data, 0, read);
                }
                if (ImageUtil.isResizableImage(fname)) {
                    ImageUtil.scaleDownAndSaveWithMaxDimension(fname, 1024);
                }
            }
            String string2 = fname;
            return string2;
        }
        catch (NullPointerException e) {
            HSLogger.d(TAG, "NPE", e);
            String string3 = null;
            return string3;
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }

    public static void copyAttachment(@NonNull ImagePickerFile imagePickerFile, @Nullable String refersId) throws IOException {
        Uri uri = (Uri)imagePickerFile.transientUri;
        if (uri == null) {
            HSLogger.d(TAG, "Can't proceed if uri is null");
            return;
        }
        Context context = HelpshiftContext.getApplicationContext();
        HSApiData hsApiData = new HSApiData(context);
        InputStream input = null;
        FileOutputStream output = null;
        String fileExtension = "." + FileUtil.getFileExtensionFromMimeType(context, uri);
        String outputName = AttachmentUtil.buildLocalAttachmentCopyFileName(refersId, fileExtension);
        File outputFile = new File(context.getFilesDir(), outputName);
        String outputFilePath = outputFile.getAbsolutePath();
        if (!outputFile.exists()) {
            int read;
            hsApiData.storeFile(outputName);
            input = context.getContentResolver().openInputStream(uri);
            output = context.openFileOutput(outputName, 0);
            byte[] data = new byte[8192];
            while ((read = input.read(data)) != -1) {
                output.write(data, 0, read);
            }
            imagePickerFile.filePath = outputFilePath;
            imagePickerFile.isFileCompressionAndCopyingDone = true;
            if (ImageUtil.isResizableImage(outputFilePath)) {
                ImageUtil.scaleDownAndSaveWithMaxDimension(outputFilePath, 1024);
            }
        }
        if (output != null) {
            output.close();
        }
        if (input != null) {
            input.close();
        }
    }

    public static String buildLocalAttachmentCopyFileName(@Nullable String refersId, String fileExtension) {
        String messageId = refersId == null ? "localRscMessage_" + UUID.randomUUID().toString() : refersId;
        return messageId + "0-thumbnail" + fileExtension;
    }

    public static String getFileName(String filePath) {
        String fileName = "";
        if (filePath != null) {
            File file = new File(filePath);
            fileName = file.getName();
        }
        return fileName;
    }

    private static int getExifRotation(String path) {
        try {
            String mimeType = FileUtil.getMimeType(path);
            if (mimeType != null && mimeType.contains("jpeg")) {
                ExifInterface exifInterface = new ExifInterface(path);
                int exifOrientation = exifInterface.getAttributeInt("Orientation", 1);
                if (exifOrientation == 6) {
                    return 90;
                }
                if (exifOrientation == 3) {
                    return 180;
                }
                if (exifOrientation == 8) {
                    return 270;
                }
                return 0;
            }
        }
        catch (Exception e) {
            HSLogger.e(TAG, "Exception in getting exif rotation", e);
        }
        return 0;
    }
}

