/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import com.helpshift.R;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.support.compositions.FaqFragment;
import com.helpshift.support.fragments.FaqFlowFragment;
import com.helpshift.support.fragments.ScreenshotPreviewFragment;
import com.helpshift.support.fragments.SearchFragment;
import com.helpshift.support.fragments.SingleQuestionFragment;
import com.helpshift.support.fragments.SupportFragment;
import java.util.List;

public class FragmentUtil {
    public static void startFragment(FragmentManager fragmentManager, int fragmentContainerId, Fragment fragment, String tag, String backStackName, boolean executePendingTransactions, boolean disableAnimation) {
        FragmentUtil.loadFragment(fragmentManager, fragmentContainerId, fragment, tag, backStackName, executePendingTransactions, disableAnimation);
    }

    public static void startFragmentWithBackStack(FragmentManager fragmentManager, int fragmentContainerId, Fragment fragment, String tag, boolean executePendingTransactions) {
        FragmentUtil.loadFragment(fragmentManager, fragmentContainerId, fragment, tag, fragment.getClass().getName(), executePendingTransactions, false);
    }

    public static void startFragmentWithoutBackStack(FragmentManager fragmentManager, int fragmentContainerId, Fragment fragment, String tag, boolean executePendingTransactions) {
        FragmentUtil.loadFragment(fragmentManager, fragmentContainerId, fragment, tag, null, executePendingTransactions, false);
    }

    public static void popBackStack(FragmentManager fragmentManager, String backStackName) {
        fragmentManager.popBackStack(backStackName, 1);
    }

    public static void popBackStackImmediate(FragmentManager fragmentManager, String backStackName) {
        fragmentManager.popBackStackImmediate(backStackName, 1);
    }

    public static void removeFragment(FragmentManager fragmentManager, Fragment fragment) {
        fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
    }

    public static SingleQuestionFragment getSingleQuestionFragment(FragmentManager fragmentManager) {
        List fragments = fragmentManager.getFragments();
        if (fragments != null) {
            for (Fragment fragment : fragments) {
                if (fragment == null || !(fragment instanceof SingleQuestionFragment)) continue;
                return (SingleQuestionFragment)fragment;
            }
        }
        return null;
    }

    public static ScreenshotPreviewFragment getScreenshotPreviewFragment(FragmentManager fragmentManager) {
        List fragments = fragmentManager.getFragments();
        if (fragments != null) {
            for (Fragment fragment : fragments) {
                if (fragment == null || !(fragment instanceof ScreenshotPreviewFragment)) continue;
                return (ScreenshotPreviewFragment)fragment;
            }
        }
        return null;
    }

    public static FaqFlowFragment getFaqFlowFragment(FragmentManager fragmentManager) {
        List fragments = fragmentManager.getFragments();
        if (fragments != null) {
            for (int i = fragments.size() - 1; i >= 0; --i) {
                Fragment fragment = (Fragment)fragments.get(i);
                if (fragment == null || !(fragment instanceof FaqFlowFragment)) continue;
                return (FaqFlowFragment)fragment;
            }
        }
        return null;
    }

    public static FaqFragment getFaqFragment(FragmentManager fragmentManager) {
        List fragments = fragmentManager.getFragments();
        if (fragments != null) {
            for (Fragment fragment : fragments) {
                if (fragment == null || !(fragment instanceof FaqFragment)) continue;
                return (FaqFragment)fragment;
            }
        }
        return null;
    }

    public static SearchFragment getSearchFragment(FragmentManager fragmentManager) {
        List fragments = fragmentManager.getFragments();
        if (fragments != null) {
            for (Fragment fragment : fragments) {
                if (fragment == null || !(fragment instanceof SearchFragment)) continue;
                return (SearchFragment)fragment;
            }
        }
        return null;
    }

    public static SupportFragment getSupportFragment(Fragment fragment) {
        if (fragment instanceof SupportFragment) {
            return (SupportFragment)fragment;
        }
        Fragment parentFragment = fragment.getParentFragment();
        if (parentFragment == null) {
            return null;
        }
        if (parentFragment instanceof SupportFragment) {
            return (SupportFragment)parentFragment;
        }
        return FragmentUtil.getSupportFragment(parentFragment);
    }

    private static void loadFragment(FragmentManager fragmentManager, int fragmentContainerId, Fragment fragment, String tag, String backStackName, boolean executePendingTransactions, boolean disableAnimation) {
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        Fragment previous = fragmentManager.findFragmentById(fragmentContainerId);
        if (!InfoModelFactory.getInstance().appInfoModel.disableAnimations.booleanValue()) {
            if (previous == null || disableAnimation) {
                fragmentTransaction.setCustomAnimations(0, 0, 0, 0);
            } else {
                fragmentTransaction.setCustomAnimations(R.anim.hs__slide_in_from_right, R.anim.hs__slide_out_to_left, R.anim.hs__slide_in_from_left, R.anim.hs__slide_out_to_right);
            }
        }
        fragmentTransaction.replace(fragmentContainerId, fragment, tag);
        if (!TextUtils.isEmpty((CharSequence)backStackName)) {
            fragmentTransaction.addToBackStack(backStackName);
        }
        fragmentTransaction.commitAllowingStateLoss();
        if (executePendingTransactions) {
            fragmentManager.executePendingTransactions();
        }
    }
}

