/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import com.helpshift.util.HSJSONUtils;
import com.helpshift.util.HSLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class HSCharacters {
    private static final String TAG = HSCharacters.class.getSimpleName();
    private Map<String, List<String>> characters;

    public HSCharacters(JSONObject jsonObject) {
        try {
            this.characters = new HashMap<String, List<String>>();
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.characters.put(key, HSJSONUtils.toList(jsonObject.getJSONArray(key)));
            }
        }
        catch (JSONException e) {
            HSLogger.e(TAG, "HSCharacters constructor error : " + e.getMessage());
        }
    }

    public boolean containsKey(String high, int low) {
        List<String> entries = this.characters.get(high);
        return entries != null && low < entries.size() && entries.get(low).length() > 0;
    }

    public String get(String high, int low) {
        List<String> entries = this.characters.get(high);
        if (entries == null) {
            return "";
        }
        return entries.get(low);
    }
}

