/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import com.helpshift.support.util.HSCharacters;
import com.helpshift.util.AssetsUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import org.json.JSONException;
import org.json.JSONObject;

public class HSTransliterator {
    private static final String TAG = "Helpshift_Transliteratr";
    private static boolean initDone = false;
    private static HSCharacters hsCharacters;

    public static boolean isLoaded() {
        return initDone;
    }

    public static void init() {
        if (!initDone) {
            try {
                String json = AssetsUtil.readFileAsString(HelpshiftContext.getApplicationContext(), "hs__data");
                JSONObject hsCharsJson = new JSONObject(json).getJSONObject("HSCharacters");
                if (hsCharsJson != null) {
                    hsCharacters = new HSCharacters(hsCharsJson);
                    initDone = true;
                }
            }
            catch (JSONException e) {
                HSLogger.w(TAG, "Error reading json : ", e);
            }
        }
    }

    public static void deinit() {
        hsCharacters = null;
        initDone = false;
    }

    public static String unidecode(String input) {
        char c;
        if (!initDone) {
            HSTransliterator.init();
        }
        if (input == null || input.length() == 0) {
            return "";
        }
        for (int i = 0; i < input.length() && (c = input.charAt(i)) <= '\u0080'; ++i) {
            if (i < input.length()) continue;
            return input;
        }
        char[] inputArray = input.toCharArray();
        StringBuilder output = new StringBuilder();
        for (char c2 : inputArray) {
            if (c2 < '\u0080') {
                output.append(c2);
                continue;
            }
            int high = c2 >> 8;
            int low = c2 & 0xFF;
            if (hsCharacters != null && hsCharacters.containsKey(String.valueOf(high), low)) {
                output.append(hsCharacters.get(String.valueOf(high), low));
                continue;
            }
            output.append("");
        }
        return output.toString();
    }
}

