/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.design.widget.Snackbar;
import android.view.View;
import com.helpshift.R;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.exception.ExceptionType;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.PlatformException;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.views.HSSnackbar;
import com.helpshift.views.HSToast;
import java.util.WeakHashMap;

public class SnackbarUtil {
    private static WeakHashMap<View, Snackbar> viewToSnackbarMapping = new WeakHashMap();

    public static void showSnackbar(View view, String message, int duration) {
        if (view != null) {
            Snackbar snackbar = HSSnackbar.make(view, message, duration);
            snackbar.show();
            viewToSnackbarMapping.put(view, snackbar);
        } else if (HelpshiftContext.getApplicationContext() != null) {
            int toastDuration = duration == -1 ? 0 : 1;
            HSToast.makeText(HelpshiftContext.getApplicationContext(), message, toastDuration).show();
        }
    }

    public static void showSnackbar(View view, int resId, int duration) {
        if (view != null) {
            Snackbar snackbar = HSSnackbar.make(view, resId, duration);
            snackbar.show();
            viewToSnackbarMapping.put(view, snackbar);
        } else if (HelpshiftContext.getApplicationContext() != null) {
            int toastDuration = duration == -1 ? 0 : 1;
            HSToast.makeText(HelpshiftContext.getApplicationContext(), resId, toastDuration).show();
        }
    }

    public static void showErrorSnackbar(int errorCode, View view) {
        if (errorCode == -1) {
            return;
        }
        Context helpshiftContext = HelpshiftContext.getApplicationContext();
        if (view == null && helpshiftContext == null) {
            return;
        }
        if (view != null) {
            Snackbar snackbar = HSSnackbar.make(view, SnackbarUtil.getErrorMessage(errorCode, view.getContext()), -1);
            snackbar.show();
            viewToSnackbarMapping.put(view, snackbar);
        } else {
            HSToast.makeText(helpshiftContext, SnackbarUtil.getErrorMessage(errorCode, helpshiftContext), 0).show();
        }
    }

    @NonNull
    private static String getErrorMessage(int errorCode, Context context) {
        String message = errorCode == NetworkErrorCodes.NO_CONNECTION ? context.getResources().getString(R.string.hs__network_unavailable_msg) : (errorCode == NetworkErrorCodes.CONTENT_NOT_FOUND ? context.getResources().getString(R.string.hs__data_not_found_msg) : (errorCode == NetworkErrorCodes.SCREENSHOT_UPLOAD_ERROR ? context.getResources().getString(R.string.hs__screenshot_upload_error_msg) : (errorCode == NetworkErrorCodes.UNKNOWN_HOST_ERROR ? context.getResources().getString(R.string.hs__could_not_reach_support_msg) : (errorCode == 100 ? context.getResources().getString(R.string.hs__could_not_open_attachment_msg) : (errorCode == 101 ? context.getResources().getString(R.string.hs__file_not_found_msg) : (errorCode == NetworkErrorCodes.SSL_PEER_UNVERIFIED_ERROR ? context.getResources().getString(R.string.hs__ssl_peer_unverified_error) : (errorCode == NetworkErrorCodes.SSL_HANDSHAKE_ERROR ? context.getResources().getString(R.string.hs__ssl_handshake_error) : (errorCode == 102 ? context.getResources().getString(R.string.hs__invalid_faq_publish_id_error) : (errorCode == 103 ? context.getResources().getString(R.string.hs__invalid_section_publish_id_error) : context.getResources().getString(R.string.hs__network_error_msg))))))))));
        return message;
    }

    public static void showSnackbar(ExceptionType errorCode, View view) {
        Context helpshiftContext = HelpshiftContext.getApplicationContext();
        if (view == null && helpshiftContext == null) {
            return;
        }
        if (view != null) {
            Snackbar snackbar = HSSnackbar.make(view, SnackbarUtil.getErrorMessage(errorCode, view.getContext()), -1);
            snackbar.show();
            viewToSnackbarMapping.put(view, snackbar);
        } else {
            HSToast.makeText(helpshiftContext, SnackbarUtil.getErrorMessage(errorCode, helpshiftContext), 0).show();
        }
    }

    private static String getErrorMessage(ExceptionType code, Context context) {
        String message = code == NetworkException.NO_CONNECTION ? context.getResources().getString(R.string.hs__network_unavailable_msg) : (code == NetworkException.UNKNOWN_HOST ? context.getResources().getString(R.string.hs__could_not_reach_support_msg) : (code == NetworkException.SSL_PEER_UNVERIFIED ? context.getResources().getString(R.string.hs__ssl_peer_unverified_error) : (code == NetworkException.SSL_HANDSHAKE ? context.getResources().getString(R.string.hs__ssl_handshake_error) : (code == NetworkException.CONTENT_NOT_FOUND ? context.getResources().getString(R.string.hs__data_not_found_msg) : (code == NetworkException.SCREENSHOT_UPLOAD_ERROR ? context.getResources().getString(R.string.hs__screenshot_upload_error_msg) : (code == PlatformException.NO_APPS_FOR_OPENING_ATTACHMENT ? context.getResources().getString(R.string.hs__could_not_open_attachment_msg) : (code == PlatformException.FILE_NOT_FOUND ? context.getResources().getString(R.string.hs__file_not_found_msg) : context.getResources().getString(R.string.hs__network_error_msg))))))));
        return message;
    }

    public static void hideSnackbar(View view) {
        if (view == null) {
            return;
        }
        if (viewToSnackbarMapping.containsKey(view)) {
            Snackbar snackbar = viewToSnackbarMapping.get(view);
            if (snackbar != null && snackbar.isShown()) {
                snackbar.dismiss();
            }
            viewToSnackbarMapping.remove(view);
        }
    }

    public static class SnackbarErrorCodes {
        public static final int NO_APPS_FOR_OPENING_ATTACHMENT = 100;
        public static final int FILE_NOT_FOUND = 101;
        public static final int INVALID_FAQ_PUBLISH_ID = 102;
        public static final int INVALID_SECTION_PUBLISH_ID = 103;
    }
}

