/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.widget.ProgressBar;
import com.helpshift.R;
import com.helpshift.support.Faq;
import com.helpshift.support.util.HSTransliterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Styles {
    public static int getColor(Context context, int attribute) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(new int[]{attribute});
        int color2 = typedArray.getColor(0, -1);
        typedArray.recycle();
        return color2;
    }

    public static void setSendMessageButtonIconColor(Context context, Drawable sendMessageButtonIcon, boolean isActive) {
        int color2 = isActive ? R.attr.colorAccent : 16842906;
        com.helpshift.util.Styles.setColorFilter(context, sendMessageButtonIcon, color2);
    }

    public static void setAdminChatBubbleColor(Context context, Drawable adminChatBubbleNinePatch) {
        com.helpshift.util.Styles.setColorFilter(context, adminChatBubbleNinePatch, R.attr.hs__chatBubbleAdminBackgroundColor);
    }

    public static void setUserChatBubbleColor(Context context, Drawable userChatBubbleNinePatch) {
        com.helpshift.util.Styles.setColorFilter(context, userChatBubbleNinePatch, R.attr.hs__chatBubbleUserBackgroundColor);
    }

    public static void setAccentColor(Context context, Drawable ratingBar) {
        com.helpshift.util.Styles.setColorFilter(context, ratingBar, R.attr.colorAccent);
    }

    public static void setAttachmentProgressBarColor(Context context, ProgressBar progressBar) {
        int color2 = ContextCompat.getColor((Context)context, (int)R.color.hs__color_FFFFFFFF);
        com.helpshift.util.Styles.setColorFilter(progressBar.getIndeterminateDrawable(), color2);
    }

    public static void setImageAttachmentProgressBackgroundColor(Context context, Drawable background) {
        int color2 = ContextCompat.getColor((Context)context, (int)R.color.hs__color_FF000000);
        com.helpshift.util.Styles.setColorFilter(background, color2);
    }

    public static Faq getQuestionWithHighlightedSearchTerms(Context context, Faq question, ArrayList<String> searchTerms) {
        Faq newQuestion = null;
        if (searchTerms != null && searchTerms.size() > 0) {
            boolean isEnglish;
            Collections.sort(searchTerms);
            Collections.reverse(searchTerms);
            String titleText = question.title;
            String bodyText = question.body;
            LinkedHashSet<String> reverseTransKeywords = new LinkedHashSet<String>();
            String hexColor = com.helpshift.util.Styles.getHexColor(context, R.attr.hs__searchHighlightColor);
            boolean bl = isEnglish = HSTransliterator.unidecode(titleText).equals(titleText) && HSTransliterator.unidecode(bodyText).equals(bodyText);
            if (!isEnglish) {
                int titleLength = titleText.length();
                String titleTrans = "";
                ArrayList<Integer> titleIndex = new ArrayList<Integer>();
                for (int i = 0; i < titleLength; ++i) {
                    char character = titleText.charAt(i);
                    String charTransliteration = HSTransliterator.unidecode(character + "");
                    for (int j = 0; j < charTransliteration.length(); ++j) {
                        titleTrans = titleTrans + charTransliteration.charAt(j);
                        titleIndex.add(i);
                    }
                }
                titleTrans = titleTrans.toLowerCase();
                int bodyLength = bodyText.length();
                HSTransliterator.unidecode(bodyText);
                String bodyTrans = "";
                ArrayList<Integer> bodyIndex = new ArrayList<Integer>();
                for (int i = 0; i < bodyLength; ++i) {
                    char character = bodyText.charAt(i);
                    String charTransliteration = HSTransliterator.unidecode(character + "");
                    for (int j = 0; j < charTransliteration.length(); ++j) {
                        bodyTrans = bodyTrans + charTransliteration.charAt(j);
                        bodyIndex.add(i);
                    }
                }
                bodyTrans = bodyTrans.toLowerCase();
                for (String word : searchTerms) {
                    String reverseTransKeyword;
                    int endIndex;
                    int startIndex;
                    if (word.length() < 3) continue;
                    word = word.toLowerCase();
                    int index = TextUtils.indexOf((CharSequence)titleTrans, (CharSequence)word, (int)0);
                    while (index >= 0) {
                        startIndex = (Integer)titleIndex.get(index);
                        endIndex = (Integer)titleIndex.get(index + word.length() - 1);
                        reverseTransKeyword = titleText.substring(startIndex, endIndex + 1);
                        reverseTransKeywords.add(reverseTransKeyword);
                        index = TextUtils.indexOf((CharSequence)titleTrans, (CharSequence)word, (int)(index + word.length()));
                    }
                    index = TextUtils.indexOf((CharSequence)bodyTrans, (CharSequence)word, (int)0);
                    while (index >= 0) {
                        startIndex = (Integer)bodyIndex.get(index);
                        endIndex = (Integer)bodyIndex.get(index + word.length() - 1);
                        reverseTransKeyword = bodyText.substring(startIndex, endIndex + 1);
                        reverseTransKeywords.add(reverseTransKeyword);
                        index = TextUtils.indexOf((CharSequence)bodyTrans, (CharSequence)word, (int)(index + word.length()));
                    }
                }
            } else {
                for (String word : searchTerms) {
                    if (word.length() < 3) continue;
                    reverseTransKeywords.add(word);
                }
            }
            bodyText = ">" + bodyText + "<";
            titleText = ">" + titleText + "<";
            Pattern pattern = Pattern.compile(">[^<]+<");
            for (String reverseTransWord : reverseTransKeywords) {
                String titleTextCopy = titleText;
                Matcher matcher = pattern.matcher(titleTextCopy);
                while (matcher.find()) {
                    String content = titleTextCopy.substring(matcher.start(), matcher.end());
                    String formattedContent = content.replaceAll("(?i)(" + reverseTransWord + ")", "<span style=\"background-color: " + hexColor + "\">$1</span>");
                    titleText = titleText.replace(content, formattedContent);
                }
                String bodyTextCopy = bodyText;
                matcher = pattern.matcher(bodyTextCopy);
                while (matcher.find()) {
                    String content = bodyTextCopy.substring(matcher.start(), matcher.end());
                    String formattedContent = content.replaceAll("(?i)(" + reverseTransWord + ")", "<span style=\"background-color: " + hexColor + "\">$1</span>");
                    bodyText = bodyText.replace(content, formattedContent);
                }
            }
            titleText = titleText.substring(1, titleText.length() - 1);
            bodyText = bodyText.substring(1, bodyText.length() - 1);
            newQuestion = new Faq(1L, question.getId(), question.publish_id, question.section_publish_id, titleText, bodyText, question.is_helpful, question.is_rtl, question.getTags(), question.getCategoryTags());
        }
        return newQuestion;
    }
}

