/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.views;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.LinearLayout;
import com.helpshift.R;
import com.helpshift.support.views.DotView;

public class HSTypingIndicatorView
extends LinearLayout {
    private static final int ALPHA_LIGHT = 76;
    private static final int ALPHA_DARK = 179;
    private final long ANIMATION_DURATION = 900L;
    private final long LOOP_START_DELAY = 450L;
    Animator[] dotAnimators = new Animator[3];
    AnimatorSet dotAnimatorSet;
    private float dotDiameter;
    private DotView[] dots;
    private int LightDotColor;
    private float interDotPadding;

    public HSTypingIndicatorView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HSTypingIndicatorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttributes(context, attrs);
        this.setup();
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        TypedArray array = context.getTheme().obtainStyledAttributes(attrs, R.styleable.HSTypingIndicatorView, 0, 0);
        int color2 = array.getColor(R.styleable.HSTypingIndicatorView_hs__dotColor, 0);
        this.LightDotColor = Color.argb((int)76, (int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2));
        this.interDotPadding = array.getDimension(R.styleable.HSTypingIndicatorView_hs__interDotPadding, 0.0f);
        this.dotDiameter = array.getDimension(R.styleable.HSTypingIndicatorView_hs__dotDiameter, 0.0f);
        array.recycle();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 0) {
            this.startTypingAnimation();
        } else {
            this.stopTypingAnimation();
        }
    }

    private void startTypingAnimation() {
        if (this.dotAnimatorSet == null) {
            this.dotAnimatorSet = new AnimatorSet();
            this.dotAnimatorSet.playTogether(this.dotAnimators);
            this.dotAnimatorSet.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    animation.setStartDelay(450L);
                    animation.start();
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.dotAnimatorSet.start();
        }
    }

    private void stopTypingAnimation() {
        if (this.dotAnimatorSet != null) {
            for (Animator animator : this.dotAnimatorSet.getChildAnimations()) {
                animator.cancel();
            }
            this.dotAnimatorSet.cancel();
            this.dotAnimatorSet = null;
            for (DotView dot : this.dots) {
                dot.setDotColor(this.LightDotColor);
            }
        }
    }

    private void setup() {
        this.dots = new DotView[3];
        for (int i = 0; i < 3; ++i) {
            this.dots[i] = new DotView(this.getContext(), this.LightDotColor);
            float leftPadding = this.interDotPadding / 2.0f;
            float rightPadding = this.interDotPadding / 2.0f;
            long startDelay = 0L;
            switch (i) {
                case 0: {
                    leftPadding = 0.0f;
                    break;
                }
                case 1: {
                    startDelay = 225L;
                    break;
                }
                case 2: {
                    rightPadding = 0.0f;
                    startDelay = 450L;
                }
            }
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams((int)this.dotDiameter, (int)this.dotDiameter);
            params.setMargins((int)leftPadding, 0, (int)rightPadding, 0);
            this.addView(this.dots[i], (ViewGroup.LayoutParams)params);
            this.dotAnimators[i] = this.getAnimator(startDelay, this.dots[i]);
        }
    }

    public ValueAnimator getAnimator(long startDelay, ValueAnimator.AnimatorUpdateListener listener) {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{76, 179, 76});
        animator.setStartDelay(startDelay);
        animator.setDuration(900L);
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.addUpdateListener(listener);
        return animator;
    }
}

