/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.webkit;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;

public class CustomWebChromeClient
extends WebChromeClient {
    private final View decorView;
    private final View webviewContentView;
    private final ViewGroup fullScreenContainer;
    private WebChromeClient.CustomViewCallback callback;
    private View customView;

    public CustomWebChromeClient(View decorView, View webviewContentView) {
        this.decorView = decorView;
        this.webviewContentView = webviewContentView;
        this.fullScreenContainer = (ViewGroup)decorView.findViewById(0x1020002);
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        if (this.customView != null) {
            callback.onCustomViewHidden();
            return;
        }
        this.fullScreenContainer.addView(view);
        this.customView = view;
        this.customView.setBackgroundColor(-16777216);
        this.callback = callback;
        this.webviewContentView.setVisibility(8);
        this.enableFullScreen();
    }

    public void onHideCustomView() {
        if (this.customView == null) {
            return;
        }
        this.customView.setVisibility(8);
        this.fullScreenContainer.removeView(this.customView);
        this.customView = null;
        if (this.callback != null) {
            this.callback.onCustomViewHidden();
        }
        this.webviewContentView.setVisibility(0);
        this.disableFullScreen();
    }

    private void enableFullScreen() {
        int newUiOptions = this.decorView.getSystemUiVisibility();
        if (Build.VERSION.SDK_INT >= 14) {
            newUiOptions |= 2;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            newUiOptions |= 4;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            newUiOptions |= 0x1000;
        }
        this.decorView.setSystemUiVisibility(newUiOptions);
    }

    private void disableFullScreen() {
        int newUiOptions = this.decorView.getSystemUiVisibility();
        if (Build.VERSION.SDK_INT >= 14) {
            newUiOptions &= 0xFFFFFFFD;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            newUiOptions &= 0xFFFFFFFB;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            newUiOptions &= 0xFFFFEFFF;
        }
        this.decorView.setSystemUiVisibility(newUiOptions);
    }
}

