/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.webkit;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.helpshift.util.FileUtil;
import com.helpshift.util.HSLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class CustomWebViewClient
extends WebViewClient {
    public static final String TAG = CustomWebViewClient.class.getSimpleName();
    private Context context;
    private final CustomWebViewClientListeners customWebViewClientListeners;

    public CustomWebViewClient(Context context, CustomWebViewClientListeners customWebViewClientListeners) {
        this.customWebViewClientListeners = customWebViewClientListeners;
        this.context = context;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        Context context = view.getContext();
        if (!TextUtils.isEmpty((CharSequence)url)) {
            Intent intent = new Intent("android.intent.action.VIEW");
            Uri data = Uri.parse((String)url);
            intent.setData(data);
            if (intent.resolveActivity(context.getPackageManager()) != null) {
                context.startActivity(intent);
                return true;
            }
        }
        return super.shouldOverrideUrlLoading(view, url);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.customWebViewClientListeners.onPageStarted();
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        this.customWebViewClientListeners.onPageFinished();
    }

    @TargetApi(value=11)
    public WebResourceResponse shouldInterceptRequest(WebView view, String inputUrl) {
        URL url = null;
        File storagePath = this.context.getExternalCacheDir();
        try {
            url = new URL(inputUrl);
        }
        catch (MalformedURLException e) {
            HSLogger.d(TAG, "MalformedURLException", e);
        }
        if (url != null) {
            File saveFile = new File(storagePath, inputUrl.replace("/", "_"));
            if (saveFile.exists()) {
                try {
                    return new WebResourceResponse("", "", (InputStream)new FileInputStream(saveFile));
                }
                catch (FileNotFoundException e) {
                    HSLogger.w(TAG, "FileNotFoundException", e);
                }
            } else if (FileUtil.isImage(url)) {
                FileUtil.saveFile(url, saveFile);
            }
        }
        return super.shouldInterceptRequest(view, inputUrl);
    }

    public static interface CustomWebViewClientListeners {
        public void onPageStarted();

        public void onPageFinished();
    }
}

