/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.widget;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RatingBar;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.support.util.Styles;
import com.helpshift.support.widget.CSATView;
import com.helpshift.util.HelpshiftContext;

public class CSATDialog
extends Dialog
implements DialogInterface.OnShowListener,
DialogInterface.OnDismissListener,
View.OnClickListener,
View.OnTouchListener {
    private Context context;
    private CSATView csatView;
    private RatingBar dialogRatingBar;
    private TextView likeStatus;
    private EditText addtionalFeedback;
    private float rating;
    private boolean submitted = false;

    public CSATDialog(Context context) {
        super(context);
        this.context = context;
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hs__csat_dialog);
        this.setOnShowListener(this);
        this.setOnDismissListener(this);
        this.dialogRatingBar = (RatingBar)this.findViewById(R.id.ratingBar);
        Styles.setAccentColor(this.getContext(), this.dialogRatingBar.getProgressDrawable());
        this.dialogRatingBar.setOnTouchListener((View.OnTouchListener)this);
        this.likeStatus = (TextView)this.findViewById(R.id.like_status);
        this.addtionalFeedback = (EditText)this.findViewById(R.id.additional_feedback);
        Button submit = (Button)this.findViewById(R.id.submit);
        submit.setOnClickListener((View.OnClickListener)this);
    }

    public void onShow(DialogInterface dialogInterface) {
        HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(AnalyticsEventType.START_CSAT_RATING);
        this.dialogRatingBar.setRating(this.rating);
        String ratingValue = this.context.getResources().getQuantityString(R.plurals.hs__csat_rating_value, (int)this.rating, new Object[]{(int)this.rating});
        if ((double)this.rating > 2.0) {
            this.likeStatus.setText(R.string.hs__csat_like_message);
        } else {
            this.likeStatus.setText(R.string.hs__csat_dislike_message);
        }
        this.dialogRatingBar.setContentDescription((CharSequence)ratingValue);
    }

    public void onDismiss(DialogInterface dialogInterface) {
        if (this.submitted) {
            this.csatView.dismiss();
        } else {
            HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(AnalyticsEventType.CANCEL_CSAT_RATING);
            this.csatView.getRatingBar().setRating(0.0f);
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.submit) {
            this.csatView.sendCSATSurvey(this.dialogRatingBar.getRating(), this.addtionalFeedback.getText().toString());
            this.submitted = true;
            this.dismiss();
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        int id2 = view.getId();
        return id2 == R.id.ratingBar;
    }

    protected void show(CSATView csatView) {
        this.csatView = csatView;
        this.rating = csatView.getRatingBar().getRating();
        this.show();
    }
}

