/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.widget;

import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.v4.app.Fragment;
import com.helpshift.common.StringUtils;
import com.helpshift.common.platform.Device;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.support.util.AttachmentUtil;
import com.helpshift.util.FileUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.ImageUtil;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;

public class ImagePicker<T extends Fragment> {
    private final String KEY_EXTRA_DATA = "key_extra_data";
    public static final int PICK_IMAGE_REQUEST_ID = 1;
    public static final int PICK_IMAGE_WITHOUT_PERMISSIONS_REQUEST_ID = 2;
    public static final int IMAGE_FILE_NOT_FOUND = -1;
    public static final int INVALID_IMAGE_URI = -2;
    public static final int IMAGE_FILE_SIZE_LIMIT_EXCEEDED = -3;
    public static final int NO_APPS_TO_OPEN_IMAGES_INTENT = -4;
    private static final long MAX_IMAGE_FILE_SIZE_LIMIT = 0x1900000L;
    private Device device = HelpshiftContext.getPlatform().getDevice();
    private WeakReference<T> imagePickerListenerRef;
    private Bundle extraData;
    private static final String TAG = "Helpshift_ImagePicker";

    public ImagePicker(T imagePickerListener) {
        this.imagePickerListenerRef = new WeakReference<T>(imagePickerListener);
    }

    public void checkPermissionAndLaunchImagePicker(Bundle extraData) {
        HSLogger.d(TAG, "Checking permission before launching attachment picker");
        switch (this.device.checkPermission(Device.PermissionType.READ_STORAGE)) {
            case AVAILABLE: {
                this.launchImagePicker(extraData);
                break;
            }
            case UNAVAILABLE: {
                HSLogger.d(TAG, "READ_STORAGE permission is not granted and can't be requested, starting alternate flow");
                this.launchImagePicker(extraData, 2);
                break;
            }
            case REQUESTABLE: {
                HSLogger.d(TAG, "READ_STORAGE permission is not granted but can be requested");
                Fragment imagePickerListener1 = (Fragment)this.imagePickerListenerRef.get();
                if (imagePickerListener1 == null) break;
                ((ImagePickerListener)imagePickerListener1).askForReadStoragePermission();
            }
        }
    }

    public void launchImagePicker(Bundle extraData) {
        this.launchImagePicker(extraData, 1);
    }

    private void launchImagePicker(Bundle extraData, int flowRequestCode) {
        Intent pickImageIntent;
        this.extraData = extraData;
        HSLogger.d(TAG, "Launching attachment picker now, flowRequestCode: " + flowRequestCode);
        Context context = HelpshiftContext.getApplicationContext();
        int osVersion = HelpshiftContext.getPlatform().getDevice().getOSVersionNumber();
        if (flowRequestCode == 2 && osVersion >= 19) {
            pickImageIntent = new Intent("android.intent.action.OPEN_DOCUMENT");
            pickImageIntent.setType("image/*");
            pickImageIntent.addFlags(1);
            pickImageIntent.putExtra("android.intent.extra.LOCAL_ONLY", true);
        } else {
            pickImageIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            if (pickImageIntent.resolveActivity(context.getPackageManager()) != null) {
                this.startActivityForResult(pickImageIntent, flowRequestCode);
                return;
            }
            pickImageIntent = new Intent("android.intent.action.GET_CONTENT");
            pickImageIntent.setType("image/*");
            if (osVersion >= 11) {
                pickImageIntent.putExtra("android.intent.extra.LOCAL_ONLY", true);
            }
        }
        if (pickImageIntent.resolveActivity(context.getPackageManager()) == null) {
            HSLogger.e(TAG, "No app found for handling image pick intent " + pickImageIntent);
            this.sendImagePickerResultFailureCallback(-4, null);
        } else {
            this.startActivityForResult(pickImageIntent, flowRequestCode);
        }
    }

    public void onImagePickRequestResult(int requestCode, Intent intent) {
        Uri uri = intent.getData();
        if (requestCode == 1) {
            this.processUriWithPermissionsAvailable(uri);
        } else if (requestCode == 2) {
            int takeFlags = intent.getFlags();
            takeFlags &= 1;
            if (Build.VERSION.SDK_INT >= 19) {
                HelpshiftContext.getApplicationContext().getContentResolver().takePersistableUriPermission(uri, takeFlags);
            }
            this.processUriWithPermissionsUnavailable(uri);
        }
    }

    private void processUriWithPermissionsAvailable(Uri uri) {
        HSLogger.d(TAG, "Processing image uri with flow when permissions are available: " + uri);
        if (this.isImageUriValid(uri)) {
            File file = this.getImageFileFromMediaStorage(uri);
            if (file != null && file.exists()) {
                ImagePickerFile imagePickerFile = this.createImagePickerFileFromPath(file.getPath());
                if (imagePickerFile.originalFileSize <= 0x1900000L || ImageUtil.isResizableImage(file.getPath())) {
                    String path = file.getPath();
                    HSLogger.d(TAG, "Image picker result success, path: " + path);
                    this.sendImagePickerResultSuccessCallback(imagePickerFile, this.extraData);
                } else {
                    HSLogger.d(TAG, "Image picker file size limit exceeded (in bytes): " + imagePickerFile.originalFileName + ", returning failure");
                    this.sendImagePickerResultFailureCallback(-3, 0x1900000L);
                }
            } else {
                HSLogger.d(TAG, "Image picker file reading error, returning failure");
                this.sendImagePickerResultFailureCallback(-1, null);
            }
        } else {
            HSLogger.d(TAG, "Image picker file invalid mime type, returning failure");
            this.sendImagePickerResultFailureCallback(-2, null);
        }
    }

    private void processUriWithPermissionsUnavailable(Uri uri) {
        HSLogger.d(TAG, "Processing image uri with flow when permissions are not available: " + uri);
        if (this.isImageUriValid(uri)) {
            Context context = HelpshiftContext.getApplicationContext();
            if (FileUtil.doesFileFromUriExistAndCanRead(uri, context)) {
                ImagePickerFile imagePickerFile = this.createImagePickerFileFromUri(uri);
                Long fileSize = imagePickerFile.originalFileSize;
                if (fileSize == null || fileSize <= 0x1900000L || ImageUtil.isResizableImage(uri, context)) {
                    HSLogger.d(TAG, "Image picker result success, path: " + uri);
                    this.sendImagePickerResultSuccessCallback(imagePickerFile, this.extraData);
                } else {
                    HSLogger.d(TAG, "Image picker file size limit exceeded (in bytes): " + fileSize + ", returning failure");
                    this.sendImagePickerResultFailureCallback(-3, 0x1900000L);
                }
            } else {
                HSLogger.d(TAG, "Image picker file reading error, returning failure");
                this.sendImagePickerResultFailureCallback(-1, null);
            }
        } else {
            HSLogger.d(TAG, "Image picker file invalid mime type, returning failure");
            this.sendImagePickerResultFailureCallback(-2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImagePickerFile createImagePickerFileFromUri(Uri uri) {
        Context context = HelpshiftContext.getApplicationContext();
        Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
        Long size = null;
        String displayName = null;
        try {
            if (cursor != null && cursor.moveToFirst()) {
                String sizeString;
                int sizeIndex;
                displayName = cursor.getString(cursor.getColumnIndex("_display_name"));
                if (StringUtils.isEmpty(displayName)) {
                    displayName = UUID.randomUUID().toString();
                }
                if (!cursor.isNull(sizeIndex = cursor.getColumnIndex("_size")) && (sizeString = cursor.getString(sizeIndex)) != null) {
                    try {
                        size = Long.valueOf(sizeString);
                    }
                    catch (NumberFormatException e) {
                        HSLogger.d(TAG, "Error getting size due to " + e);
                    }
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return new ImagePickerFile(uri, displayName, size);
    }

    private ImagePickerFile createImagePickerFileFromPath(String originalPath) {
        String fileName = AttachmentUtil.getFileName(originalPath);
        Long size = null;
        if (originalPath != null) {
            File file = new File(originalPath);
            size = file.length();
        }
        return new ImagePickerFile(originalPath, fileName, size);
    }

    private boolean isImageUriValid(Uri uri) {
        Context context = HelpshiftContext.getApplicationContext();
        ContentResolver contentResolver = context.getContentResolver();
        String mimeType = contentResolver.getType(uri);
        String[] includeExts = new String[]{"image/jpeg", "image/png", "image/gif", "image/x-png", "image/x-citrix-pjpeg", "image/x-citrix-gif", "image/pjpeg"};
        HashSet<String> allowedMimeTypes = new HashSet<String>(Arrays.asList(includeExts));
        return allowedMimeTypes.contains(mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getImageFileFromMediaStorage(Uri uri) {
        Cursor cursor = null;
        File screenshotFile = null;
        String[] projection = new String[]{"_data"};
        try {
            int column_index;
            String path;
            Context context = HelpshiftContext.getApplicationContext();
            ContentResolver contentResolver = context.getContentResolver();
            cursor = contentResolver.query(uri, projection, null, null, null);
            if (cursor != null && cursor.moveToFirst() && (path = cursor.getString(column_index = cursor.getColumnIndexOrThrow("_data"))) != null) {
                screenshotFile = new File(path);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return screenshotFile;
    }

    private void sendImagePickerResultSuccessCallback(ImagePickerFile imagePickerFile, Bundle extraData) {
        Fragment imagePickerListener = (Fragment)this.imagePickerListenerRef.get();
        if (imagePickerListener != null) {
            ((ImagePickerListener)imagePickerListener).onImagePickerResultSuccess(imagePickerFile, extraData);
        }
    }

    private void sendImagePickerResultFailureCallback(int errorCode, Long data) {
        Fragment imagePickerListener = (Fragment)this.imagePickerListenerRef.get();
        if (imagePickerListener != null) {
            ((ImagePickerListener)imagePickerListener).onImagePickerResultFailure(errorCode, data);
        }
    }

    private void startActivityForResult(Intent intent, int requestCode) {
        try {
            Fragment fragment = (Fragment)this.imagePickerListenerRef.get();
            if (fragment != null && fragment.getActivity() != null) {
                fragment.startActivityForResult(intent, requestCode);
            }
        }
        catch (ActivityNotFoundException e) {
            HSLogger.e(TAG, "Error occurred while starting app for handling image pick intent " + (Object)((Object)e));
            this.sendImagePickerResultFailureCallback(-4, null);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putBundle("key_extra_data", this.extraData);
    }

    public void onViewStateRestored(Bundle savedInstanceState) {
        if (savedInstanceState.containsKey("key_extra_data")) {
            this.extraData = savedInstanceState.getBundle("key_extra_data");
        }
    }

    public static interface ImagePickerListener {
        public void askForReadStoragePermission();

        public void onImagePickerResultSuccess(ImagePickerFile var1, Bundle var2);

        public void onImagePickerResultFailure(int var1, Long var2);
    }
}

